<?php
/**
 * @version 9.9.9
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 * @see woocommerce_default_product_tabs()
 */
$tabs = apply_filters( 'woocommerce_product_tabs', array() );
$i = 0;

if ( ! empty( $tabs ) ) : ?>

<div class="clearfix"></div>

<ul class="nav nav-tabs nav-tabs-lined nav-tabs-lined-bottom">
	<?php 
		foreach ( $tabs as $key => $tab ) : 
		$active = ( 0 == $i ) ? 'active' : '';
		$i++;
	?>
		<li class="<?php echo esc_attr($active); ?>">
			<a href="#tab-<?php echo esc_attr( $key ); ?>" data-toggle="tab">
				<?php echo apply_filters( 'woocommerce_product_' . $key . '_tab_title', esc_html( $tab['title'] ), $key ); ?>
			</a>
		</li>
	<?php endforeach; ?>
</ul>

<div class="space20"></div>

<div class="tab-content">
	<?php 
		$i = 0;
		foreach ( $tabs as $key => $tab ) : 
		$active = ( 0 == $i ) ? 'in active' : '';
		$i++;
	?>
		<div class="tab-pane fade <?php echo esc_attr($active); ?>" id="tab-<?php echo esc_attr( $key ); ?>">
			<?php if ( isset( $tab['callback'] ) ) { call_user_func( $tab['callback'], $key, $tab ); } ?>
		</div>
	<?php endforeach; ?>
</div>

<?php endif; ?>
