<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $comment;
$verified = wc_review_is_from_verified_owner( $comment->comment_ID );

if ( '0' === $comment->comment_approved ) { ?>

	<p class="meta"><em class="woocommerce-review__awaiting-approval"><?php esc_attr_e( 'Your review is awaiting approval', 'creatink' ); ?></em></p>

<?php } else { ?>

	<div class="info">
		<h5><?php comment_author(); ?></h5> <?php

		if ( 'yes' === get_option( 'woocommerce_review_rating_verification_label' ) && $verified ) {
			echo '<em class="woocommerce-review__verified verified">(' . esc_attr__( 'verified owner', 'creatink' ) . ')</em> ';
		}

		?><div class="meta"> <span class="date"><?php echo get_comment_date( wc_date_format() ); ?></span></div>
	</p>

<?php }