<?php
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly
	}
	
	global $product;
	
	// Ensure visibility
	if ( empty( $product ) || ! $product->is_visible() ) {
		return;
	}
	
	$attachment_ids = $product->get_gallery_image_ids();
?>

<div class="item grid-sizer col-xs-12 col-sm-12 col-md-6">
	
	<?php woocommerce_show_product_loop_sale_flash(); ?>

	<figure class="overlay overlay8">
	
		<a href="<?php the_permalink(); ?>"></a>
		
		<?php 
			if ( isset($attachment_ids[1]) && has_post_thumbnail() ) {
			
				the_post_thumbnail( 'ebor_square', array( 'class' => 'primary' ) ); 
				echo wp_get_attachment_image( $attachment_ids[1], 'ebor_square', 0, array( 'class' => 'secondary' ) );

			} else {
			
				the_post_thumbnail( 'ebor_square' ); 
				
			}
		?>
		
		<figcaption>
			<h5 class="mb-0"><?php esc_html_e( 'View Details', 'creatink' ); ?></h5>
		</figcaption>
		
	</figure>
	
	<div class="post-content text-center">
		<?php the_title( '<h3 class="post-title"><a href="'. get_permalink() .'">', '</a></h3>' ); ?>
		<div class="meta price"><?php woocommerce_template_loop_price(); ?></div>
	</div>
	
</div>