<?php
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly
	}
	
	global $product;
	
	// Ensure visibility
	if ( empty( $product ) || ! $product->is_visible() ) {
		return;
	}
	
	$attachment_ids = $product->get_gallery_image_ids();
?>

<div class="item post mr-10 ml-10">
	
	<?php woocommerce_show_product_loop_sale_flash(); ?>
	
	<figure class="overlay overlay1">
		<a href="<?php the_permalink(); ?>"></a>
		<?php the_post_thumbnail( 'ebor_square' ); ?>
		<figcaption>
			<h5 class="from-top"><?php esc_html_e( 'View Details', 'creatink' ); ?></h5>
		</figcaption>
	</figure>
	
	<div class="post-content text-center mt-20">
		<?php the_title( '<h3 class="post-title"><a href="'. get_permalink() .'">', '</a></h3>' ); ?>
		<div class="meta price"><?php woocommerce_template_loop_price(); ?></div>
	</div>
	
</div><!-- /.item -->