<?php 

remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

/**
 * Output WooCommerce content.
 *
 * This function is only used in the optional 'woocommerce.php' template.
 * which people can add to their themes to add basic woocommerce support.
 * without hooks or modifying core templates.
 *
 */
if ( ! function_exists( 'woocommerce_content' ) ) {
    function woocommerce_content() {

        if ( is_singular( 'product' ) ) {

            while ( have_posts() ) : the_post();

                wc_get_template_part( 'content', 'single-product' );

            endwhile;

        } else {

            do_action( 'woocommerce_archive_description' );
            get_template_part( 'woocommerce/loop-product', get_option( 'shop_layout', 'grid-4' ) );

        }
    }
}

add_filter('add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment');
function woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	
	ob_start();
	
	?>
	<ul class="image-list ebor_cart_list">
			<?php
				foreach ($woocommerce->cart->cart_contents as $cart_item_key => $cart_item) :
	
				$_product = $cart_item['data'];
				
				if ($_product->exists() && $cart_item['quantity']>0) :
					echo '<li><figure class="overlay overlay1">';
					echo '<a href="'.get_permalink($cart_item['product_id']).'"></>';				
					if (has_post_thumbnail($cart_item['product_id'])) :					
						echo get_the_post_thumbnail($cart_item['product_id'], 'shop_thumbnail'); 
					else :					 
						echo '<img src="'.$woocommerce->plugin_url(). '/assets/images/placeholder.png" alt="Placeholder" width="'.$woocommerce->get_image_size('shop_thumbnail_image_width').'" height="'.$woocommerce->get_image_size('shop_thumbnail_image_height').'" />'; 				
					endif;				

					echo '<figcaption>
							<i class="et-link from-top icon-xs"></i>
						</figcaption></figure>';
					
					echo '<div class="post-content">';
					echo '<h6 class="post-title"><a href="'.get_permalink($cart_item['product_id']).'">';				
					echo apply_filters('woocommerce_cart_widget_product_title', $_product->get_title(), $_product);				
					if ($_product instanceof woocommerce_product_variation && is_array($cart_item['variation'])) :
						echo woocommerce_get_formatted_variation( $cart_item['variation'] );
					endif;
					echo '</a></h6><div class="meta price"><em class="quantity">' .$cart_item['quantity'].'</em><span class="amount">'.wc_price($_product->get_price()).'</span>
						  </div></div></li>';
				endif;
			endforeach;
			?>
		</ul>
	<?php
	
	$fragments['ul.ebor_cart_list'] = ob_get_clean();
	
	return $fragments;
	
}

// Ensure cart contents update when products are added to the cart via AJAX (place the following in functions.php)
add_filter('add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment_total');
function woocommerce_header_add_to_cart_fragment_total( $fragments ) {
	global $woocommerce;
	
	ob_start();
	?>
	
	<span class="amount ebor_amount"><?php echo WC()->cart->get_cart_total(); ?></span>
	
	<?php	

	$fragments['span.ebor_amount'] = ob_get_clean();
	
	return $fragments;
	
}

add_filter('add_to_cart_fragments', 'woocommerce_header_add_to_cart_count');
function woocommerce_header_add_to_cart_count( $fragments ) {
	global $woocommerce;
	
	ob_start();
	?>
	
	<span class="badge-s bg-default ebor_count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
	
	<?php	

	$fragments['span.ebor_count'] = ob_get_clean();
	
	return $fragments;
	
}