<?php 
	$id = get_the_ID(); 
	$src = get_the_post_thumbnail_url($id, 'full');
?>

<div id="portfolio-<?php the_ID(); ?>" <?php post_class( 'item mr-10 ml-10' ); ?>>
	
	<?php if( has_post_thumbnail() ) : ?>
		<figure class="overlay overlay1">
			<a href="<?php echo esc_url($src); ?>" class="lightbox-this"></a>
			<?php the_post_thumbnail( 'ebor-grid' ); ?>
			<figcaption>
				<h5 class="from-top"><?php esc_html_e( 'View Project', 'creatink' ); ?></h5>
			</figcaption>
		</figure>
	<?php endif; ?>
	
	<?php the_title('<div id="caption'. $id .'" class="hidden"><h3>', '</h3></div>'); ?>
	
	<div class="post-content text-center mt-20">
	
		<?php the_title('<h3 class="post-title"><a href="'. get_permalink() .'">', '</a></h3>'); ?>
		
		<div class="meta">
			<span class="category"><?php echo ebor_the_terms('portfolio_category', ', ', 'name'); ?></span>
		</div><!-- /.meta -->
		
	</div><!-- /.post-content --> 

</div><!-- /.item -->