<?php 
	if(!( get_the_author_meta( 'description' ) )){
		return false;
	}
	
	$icons = get_user_meta( $post->post_author, '_ebor_user_social_icons', true ); 
?>

<hr />

<div class="about-author">

	<div class="author-image">
		<?php echo get_avatar( get_the_author_meta( 'email' ), 120 ); ?>
	</div>
	
	<h4><?php esc_html_e( 'About the Author', 'creatink' ); ?></h4>
	
	<?php 
		echo wpautop( sprintf( '<span class="fn">%s</span>: %s', get_the_author(), get_the_author_meta( 'description' ) ) ); 
		
		if( is_array($icons) ){
			echo '<ul class="social social-color social-s">';
			foreach( $icons as $key => $icon ){
				if(!( isset( $icon['_ebor_social_icon_url'] ) ))
					continue;
					
				echo '<li><a href="'. esc_url($icon['_ebor_social_icon_url']) .'"><i class="'. $icon['_ebor_social_icon'] .'"></i></a></li>';
			}
			echo '</ul>';
		}
	?>
	
</div><!-- .about-author -->

<div class="clearfix"></div>