<?php 
	/**
	 * First, grab post terms.
	 */
	$terms = get_the_terms( $post->ID , 'portfolio_category', 'string');
	
	/**
	 * Return if this post has no terms
	 */
	if(!( $terms ))
		return false;
	
	/**
	 * Now we know that we definitely have terms to work with, build and array of term id's
	 */	
	$term_ids = array_values( wp_list_pluck( $terms, 'term_id' ) );
	
	/**
	 * Set our arguments for finding related posts
	 */
	$related_args = array(
		'post_type' => 'portfolio',
		'tax_query' => array(
			array(
				 'taxonomy' => 'portfolio_category',
				 'field' => 'id',
				 'terms' => $term_ids,
				 'operator'=> 'IN'
			)
		),
		'posts_per_page' => '6',
		'ignore_sticky_posts' => 1,
		'orderby' => 'rand',
		'post__not_in'=> array(
			$post->ID
		)
	);
	
	/**
	 * Build the related posts query based on what we've grabbed above
	 */
	$related_query = new WP_Query( $related_args );
	
	if ( $related_query->have_posts() ) :
?>

<div class="wrapper gray-wrapper">
	<div class="container inner">
	
		<h2 class="text-center mb-20"><?php esc_html_e( 'Other Projects', 'creatink' ); ?></h2>
		
		<div class="slick-wrapper">
		
			<div class="slick" data-slick='{"slidesToShow": 3, "responsive": [{"breakpoint":1024,"settings":{"slidesToShow": 2}},{"breakpoint":768,"settings":{"slidesToShow": 1}}]}'>
				<?php
					while ( $related_query->have_posts() ) : $related_query->the_post();
					
						/**
						 * Get blog posts by blog layout.
						 */
						get_template_part('loop/content-portfolio', 'carousel');
					
					endwhile;	
				?>
			</div><!--/.slick -->
			
			<div class="space20"></div>
			
			<div class="slick-nav-container">
				<div class="slick-nav"></div>
			</div><!--/.slick-nav-container --> 
		
		</div><!--/.slick-wrapper --> 
		
	</div>
</div>

<?php endif;