<?php 
	$header_images = get_post_meta($post->ID, '_ebor_gallery_images', 1); 
	if( is_array($header_images) ) :
?>

<div class="tiles light-gallery">
	<div class="items row text-center">
		<?php 
			$i = 0;
			foreach( $header_images as $id => $content ){
				
				$i++;
				$src  = wp_get_attachment_image_src( $id, 'full' );
				$class = (!( 3 == $i )) ? 'col-xs-12 col-sm-6 col-md-6' : 'col-xs-12 col-sm-12 col-md-12';
				
				echo '
					<div class="item '. $class .'">
						<figure class="overlay overlay1">
							<a href="'. esc_url( $src[0] ) .'"></a> 
							'. wp_get_attachment_image( $id, 'large' ) .'
							<figcaption>
								<h5 class="from-top mb-0">'. esc_html__( 'View Larger', 'creatink' ) .'</h5>
							</figcaption>
						</figure>
					</div>
				';
				
			}
		?>
	</div><!--/.row --> 
</div><!-- /.tiles -->

<?php endif;