<?php
	$show_header_cart = get_option( 'show_header_cart', 'yes' );

	if(!( class_exists('woocommerce') ))
		return false;
		
	global $woocommerce;
	$output = false;
?>

<?php if($show_header_cart == 'yes') : ?>
<li>
  	<div class="btn-group btn-cart">
  	
  		<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" data-toggle="dropdown" class="nav-link">
  			<i class="et-shopping-basket"></i>
  			<span class="badge-s bg-default"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
  		</a>
  		
  		<div class="dropdown-menu dropdown-menu-right">
  		
  			<h4><?php esc_html_e( 'Shopping Cart', 'creatink' ); ?></h4>
  			
  			<ul class="image-list">
  				<?php
  					foreach ($woocommerce->cart->cart_contents as $cart_item_key => $cart_item) :
			
						$_product = $cart_item['data'];
						
						if ($_product->exists() && $cart_item['quantity']>0) :
							$output .=  '<li><figure class="overlay overlay1">';
							$output .=  '<a href="'.get_permalink($cart_item['product_id']).'"></>';				
							if (has_post_thumbnail($cart_item['product_id'])) :					
								$output .=  get_the_post_thumbnail($cart_item['product_id'], 'shop_thumbnail'); 
							else :					 
								$output .=  '<img src="'.$woocommerce->plugin_url(). '/assets/images/placeholder.png" alt="Placeholder" width="'.$woocommerce->get_image_size('shop_thumbnail_image_width').'" height="'.$woocommerce->get_image_size('shop_thumbnail_image_height').'" />'; 				
							endif;				

							$output .=  '<figcaption>
									<i class="et-link from-top icon-xs"></i>
								</figcaption></figure>';
							
							$output .=  '<div class="post-content">';
							$output .=  '<h6 class="post-title"><a href="'.get_permalink($cart_item['product_id']).'">';				
							$output .=  apply_filters('woocommerce_cart_widget_product_title', $_product->get_title(), $_product);				
							if ($_product instanceof woocommerce_product_variation && is_array($cart_item['variation'])) :
								$output .=  woocommerce_get_formatted_variation( $cart_item['variation'] );
							endif;
							$output .=  '</a></h6><div class="meta price"><em class="quantity">' .$cart_item['quantity'].'</em><span class="amount">'.wc_price($_product->get_price()).'</span>
								  </div></div></li>';
							
						endif;
					endforeach;
					
					echo $output;
  				?>
  			</ul>

  			<hr class="pt-20 mb-20" />
  			
  			<div class="pull-left">
  				<h6 class="mb-0"><?php esc_html_e( 'Total:', 'creatink' ); ?></h6>
  				<div class="meta price mb-0">
  					<span class="amount"><?php echo WC()->cart->get_cart_total(); ?></span>
  				</div>
  			</div>

  			<div class="pull-right">
  				<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="btn btn-rounded mb-0">
  					<?php esc_html_e( 'Checkout', 'creatink' ); ?>
  				</a>
  			</div>

  		</div>

  	</div>
  </li>
<?php endif; ?>