<?php 

if(!( function_exists('ebor_pagination') )){
	function ebor_pagination($pages = '', $range = 2){
		$showitems = ($range * 2)+1;
		
		global $paged;
		if(empty($paged)) $paged = 1;
		
		if($pages == ''){
			global $wp_query;
			$pages = $wp_query->max_num_pages;
				if(!$pages) {
					$pages = 1;
				}
		}
		
		$output = '';
		
		if(1 != $pages){
			$output .= '<div class="'. get_option('pagination_style', 'pagination border text-center') .'"><ul>';
			if($paged > 2 && $paged > $range+1 && $showitems < $pages) $output .= "<li><a href='".get_pagenum_link(1)."'><i class=\"et-chevron-small-left\"></i></a></li> ";
			
			for ($i=1; $i <= $pages; $i++){
				if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
					$output .= ($paged == $i)? "<li class='active'><a href='".get_pagenum_link($i)."'><span>".$i."</span></a></li> ":"<li><a href='".get_pagenum_link($i)."'>".$i."</span></a></li> ";
				}
			}
		
			if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) $output .= "<li><a href='".get_pagenum_link($pages)."'><i class=\"et-chevron-small-right\"></i></a></li> ";
			$output.= "</ul></div>";
		}
		
		return $output;
	}
}

/**
 * CMB2 Helper Function
 */
if(!( function_exists('ebor_get_wysiwyg_output') )){
	function ebor_get_wysiwyg_output( $meta_key, $post_id = 0 ) {
		global $wp_embed;
	
		$post_id = $post_id ? $post_id : get_the_id();
	
		$content = get_post_meta( $post_id, $meta_key, 1 );
		$content = $wp_embed->autoembed( $content );
		$content = $wp_embed->run_shortcode( $content );
		$content = do_shortcode( wpautop( $content ) );
	
		return $content;
	}
}

if(!( function_exists('ebor_hex2rgb') )){
	function ebor_hex2rgb($hex) {
	
	   $hex = str_replace("#", "", $hex);
	
	   if(strlen($hex) == 3) {
	      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
	      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
	      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	   } else {
	      $r = hexdec(substr($hex,0,2));
	      $g = hexdec(substr($hex,2,2));
	      $b = hexdec(substr($hex,4,2));
	   }
	   $rgb = array($r, $g, $b);
	   
	   return implode(",", $rgb); // returns the rgb values separated by commas
	   
	}
}

/**
 * ebor_get_footer_layout
 * 
 * Use to conditionally check the page footer meta layout against the theme option for the same
 * In short, this function can override the global footer option on a post by post basis
 * Call within get_footer() for this to override the global footer choice
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_get_footer_layout') )){
	function ebor_get_footer_layout($post_id = false){
		
		if( false == $post_id ){
			
			global $post;
			
			if( isset($post->ID) ){
				$post_id = $post->ID;
			}
			
		}
		
		if(!( isset($post_id) ))
			return get_option('footer_layout', 'widgets');
		
		$footer = get_post_meta($post_id, '_ebor_footer_override', 1);
		if( '' == $footer || false == $footer || 'none' == $footer ){
			$footer = get_option('footer_layout', 'widgets');
		}
		
		return $footer;	
		
	}
}

if(!( function_exists('ebor_get_post_layout') )){
	function ebor_get_post_layout($post_id = false){
		
		if( false == $post_id ){
			
			global $post;
			
			if( isset($post->ID) ){
				$post_id = $post->ID;
			}
			
		}
		
		if(!( isset($post_id) ))
			return 'post-sidebar-right';
		
		$post_layout = get_post_meta($post_id, '_ebor_post_layout_override', 1);
		if( '' == $post_layout || false == $post_layout || 'none' == $post_layout ){
			$post_layout = 'post-sidebar-right';
		}
		
		return $post_layout;	
		
	}
}

/**
 * ebor_get_header_layout
 * 
 * Use to conditionally check the page header meta layout against the theme option for the same
 * In short, this function can override the global header option on a post by post basis
 * Call within get_header() for this to override the global header choice
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_get_header_layout') )){
	function ebor_get_header_layout($post_id = false){
		
		if( false == $post_id ){
			
			global $post;
			
			if( isset($post->ID) ){
				$post_id = $post->ID;
			}
			
		}
		
		if( is_search() || !( isset($post_id) ) )
			return get_option('header_layout', 'classic-light');
		
		$header = get_post_meta($post_id, '_ebor_header_override', 1);
		if( '' == $header || false == $header || 'none' == $header ){
			$header = get_option('header_layout', 'classic-light');
		}
		
		return $header;	
		
	}
}

/**
 * WordPress' missing is_blog_page() function.  Determines if the currently viewed page is
 * one of the blog pages, including the blog home page, archive, category/tag, author, or single
 * post pages.
 *
 * @see http://core.trac.wordpress.org/browser/tags/3.4.1/wp-includes/query.php#L1572
 *
 * @return bool
 */
if(!( function_exists('is_blog_page') )){
	function is_blog_page() {
	    global $post;
	    return ( ( is_home() || is_archive() || is_single() ) && ('post' == get_post_type($post)) ) ? true : false ;
	}
}

if(!( function_exists('ebor_breadcrumbs') )){ 
	function ebor_breadcrumbs($class = '') {
		if ( is_front_page() || is_search() || 'no' == get_option('creatink_show_breadcrumbs', 'yes') ) {
			return;
		}
		global $post;
		
		$post_type = get_post_type();
		$ancestors = array_reverse( get_post_ancestors( $post->ID ) );
		$displays = get_option('ebor_framework_cpt_display_options');
		$before = '<div class="meta breadcrumbs '. $class .' mb-0">';
		$after = '</div>';
		$home = '<span><a href="' . esc_url( home_url( "/" ) ) . '" class="home-link" rel="home">' . esc_html__( 'Home', 'creatink' ) . '</a></span>';
		
		if( 'portfolio' == $post_type ){
			$slug = ( $displays['portfolio_slug'] ) ? $displays['portfolio_slug'] : 'portfolio';
			$title = str_replace(array('-', '_'), ' ', $slug);
			$home .= '<span class="active"><a href="' . esc_url( home_url( "/". $slug ."/" ) ) . '">' . ucfirst($title) . '</a></span>';
		}
		
		if( 'team' == $post_type ){
			$slug = ( $displays['team_slug'] ) ? $displays['team_slug'] : 'team';
			$title = str_replace(array('-', '_'), ' ', $slug);
			$home .= '<span class="active"><a href="' . esc_url( home_url( "/". $slug ."/" ) ) . '">' . ucfirst($title) . '</a></span>';
		}
		
		if( 'career' == $post_type ){
			$slug = get_option('tommusrhodus_careers_slug', 'careers');
			$home .= '<span class="active"><a href="' . esc_url( home_url( "/". $slug ."/" ) ) . '">' . esc_html__( 'Careers', 'creatink' ) . '</a></span>';
		}
		
		if( class_exists('woocommerce') ){
			if( 'product' == $post_type && !(is_shop()) ){
				$home .= '<span class="active"><a href="' . esc_url( get_permalink( wc_get_page_id( 'shop' ) ) ) . '">' . esc_html__( 'Shop', 'creatink' ) . '</a></span>';
			} elseif( 'product' == $post_type && is_archive() ) {
				$home .= '<span class="active">' . esc_html__( 'Shop', 'creatink' ) . '</span>';
			}
		}
		
		$breadcrumb = '';
		if ( $ancestors ) {
			foreach ( $ancestors as $ancestor ) {
				$breadcrumb .= '<span><a href="' . esc_url( get_permalink( $ancestor ) ) . '">' . htmlspecialchars_decode( get_the_title( $ancestor ) ) . '</a></span>';
			}
		}
		
		if( is_blog_page() && is_single() ){
			$breadcrumb .= '<span><a href="' . esc_url( get_permalink( get_option( 'page_for_posts' ) ) ) . '">' . htmlspecialchars_decode( get_option('stack_blog_title', 'Our Blog') ) . '</a></span><span class="active">' . htmlspecialchars_decode( get_the_title( $post->ID ) ) . '</span>';
		} elseif( is_blog_page() ){
			$breadcrumb .= '<span class="active">' . htmlspecialchars_decode( get_option('stack_blog_title','Our Blog') ) . '</span>';
		} elseif( is_post_type_archive('product') || is_archive() ){		
			$breadcrumb .= '<span>' . htmlspecialchars_decode( single_cat_title('', false) ) . '</span>';		
		} else {
			$breadcrumb .= '<span class="active">' . htmlspecialchars_decode( get_the_title( $post->ID ) ) . '</span>';
		}
		
		return $before . $home . $breadcrumb . $after;
	}
}

if(!( function_exists('ebor_page_title') )){
	function ebor_page_title( $colour = 'light', $title = '', $description = '' ){
		
		if( $description ){
			
			$output = '
				<div class="inverse-text page-title-wrapper">
					<div class="container inner text-center">
						<h1 class="section-title">'. $title .'</h1>
						<p class="lead text-center">'. $description .'</p>
						<div class="space10"></div>
						'. ebor_breadcrumbs('align-center text-center') .'
					</div><!-- /.container -->
				</div><!-- /.parallax -->
			';	
			
		} else {
		
			if( 'dark' == $colour ){
				$class = 'dark-wrapper inverse-text';
			} elseif( 'image' == $colour ){
				$class = 'inverse-text';
			} elseif( 'color' == $colour ){
				$class = 'color-wrapper inverse-text';
			} elseif( 'gradient' == $colour ){
				$class = 'gradient-wrapper inverse-text';
			} elseif( 'pattern' == $colour ){
				$class = 'inverse-text';
			} else {
				$class = 'gray-wrapper';	
			}
	
			$output = '
				<div class="wrapper '. esc_attr($class) .' page-title-wrapper">
					<div class="container inner pt-40 pb-40 flex-it">
						<h1 class="page-title align-left mb-0">'. $title .'</h1>
						'. ebor_breadcrumbs('align-right text-right') .'
					</div>
				</div>
			';
		
		}
		
		return $output;
		
	}
}

/**
 * Init theme options
 * Certain theme options need to be written to the database as soon as the theme is installed.
 * This is either for the enqueues in ebor-framework, or to override the default image sizes in WooCommerce.
 * Either way this function is only called when the theme is first activated, de-activating and re-activating the theme will result in these options returning to defaults.
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_init_theme_options') )){
	
	/**
	 * Hook in on activation
	 */
	global $pagenow;
	
	/**
	 * Define image sizes
	 */
	function ebor_init_theme_options() {
		
		//Set all options to zero before initialising options for this theme
		$existing_options = get_option('ebor_framework_options');
		if( is_array($existing_options) ){
			foreach ($existing_options as $key => $value) {
				$existing_options[$key] = '0';
			}
			update_option('ebor_framework_options', $existing_options);
		}
		
		//Ebor Framework
		$framework_args = array(
			'portfolio_post_type'   => '1',
			'team_post_type'        => '1',
			'client_post_type'      => '1',
			'testimonial_post_type' => '1',
			'mega_menu'             => '1',
			'options'               => '1',
			'creatink_widgets'      => '1',
			'creatink_vc_shortcodes'=> '1'
		);
		update_option('ebor_framework_options', $framework_args);
		
	}
	
	/**
	 * Only call this action when we first activate the theme.
	 */
	if ( 
		is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ||
		is_admin() && isset( $_GET['theme'] ) && $pagenow == 'customize.php'
	){
		add_action( 'after_setup_theme', 'ebor_init_theme_options', 1 );
	}
	
}

/**
 * Register the required plugins for this theme.
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_register_required_plugins') )){
	function ebor_register_required_plugins() {
		$plugins = array(
			array(
			    'name'      => esc_html__('Contact Form 7', 'creatink'),
			    'slug'      => 'contact-form-7',
			    'required'  => false,
			    'version' 	=> '3.7.2'
			),
			array(
			    'name'      => esc_html__('Custom Metaboxes 2', 'creatink'),
			    'slug'      => 'cmb2',
			    'required'  => true,
			    'version' 	=> '1.0.0'
			),
			array(
			    'name'      => esc_html__('One Click Demo Import', 'creatink'),
			    'slug'      => 'one-click-demo-import',
			    'required'  => false,
			    'version' 	=> '1.0.0'
			),
			array(
			    'name'      => 'WooCommerce',
			    'slug'      => 'woocommerce',
			    'required'  => false,
			    'version' 	=> '3.0.0'
			),
			array(
				'name'     				=> esc_html__('Ebor Framework', 'creatink'),
				'slug'     				=> 'Ebor-Framework-master',
				'source'   				=> 'https://github.com/tommusrhodus/ebor-framework/archive/master.zip',
				'required' 				=> true,
				'version' 				=> '1.4.8',
				'external_url' 			=> 'https://github.com/tommusrhodus/ebor-framework/archive/master.zip',
			),
			array(
				'name'     				=> esc_html__('Visual Composer', 'creatink'),
				'slug'     				=> 'js_composer',
				'source'   				=> 'http://www.madeinebor.com/plugin-downloads/js_composer-latest.zip',
				'required' 				=> false,
				'external_url' 			=> 'http://www.madeinebor.com/plugin-downloads/js_composer-latest.zip',
				'version' 				=> '5.4.5',
			),
			array(
				'name'     				=> esc_html__( 'Revolution Slider', 'creatink' ),
				'slug'     				=> 'revslider',
				'source'   				=> 'http://www.madeinebor.com/plugin-downloads/revslider-latest.zip',
				'required' 				=> false,
				'external_url' 			=> 'http://www.madeinebor.com/plugin-downloads/revslider-latest.zip',
				'version'               => '5.4.6.4'
			),
		);
		$config = array(
			'is_automatic' => true,
		);
		tgmpa( $plugins, $config );
	}
	add_action( 'tgmpa_register', 'ebor_register_required_plugins' );
}

/**
 * Add additional styling options to TinyMCE
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_mce_before_init') )){
	function ebor_mce_before_init( $settings ) {
	    $style_formats = array(
	 
	    	array(
	    		'title'	=> 'List Styles',
	    		'items'	=> array(
	    	    	array(
	    	    		'title' => 'Bulleted List (Small)',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'unordered-list',
	    	    	),
	    	    	array(
	    	    		'title' => 'Bulleted List (Large)',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'unordered-list-disc',
	    	    	),
	    	    	array(
	    	    		'title' => 'Bulleted List (Circled)',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'unordered-list-circle',
	    	    	),
	    	    	array(
	    	    		'title' => 'Icon List',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'icon-list',
	    	    	),
	    	    	array(
	    	    		'title' => 'Numbered List',
	    	    		'selector' => 'ol',
	    	    		'classes' => 'ordered-list-number',
	    	    	),
	    	    	array(
	    	    		'title' => 'Numeral List',
	    	    		'selector' => 'ol',
	    	    		'classes' => 'ordered-list-roman',
	    	    	),
	    	    	array(
	    	    		'title' => 'Lettered List',
	    	    		'selector' => 'ol',
	    	    		'classes' => 'ordered-list-alpha',
	    	    	),
	    		)
	    	),
	    	array(
	    		'title'	=> 'List Colors',
	    		'items'	=> array(
	    	    	array(
	    	    		'title' => 'List Blue',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'list-blue',
	    	    	),
	    	    	array(
	    	    		'title' => 'List Green',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'list-green',
	    	    	),
	    	    	array(
	    	    		'title' => 'List Red',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'list-red',
	    	    	),
	    	    	array(
	    	    		'title' => 'List Pink',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'list-pink',
	    	    	),
	    	    	array(
	    	    		'title' => 'List Purple',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'list-purple',
	    	    	),
	    	    	array(
	    	    		'title' => 'List Orange',
	    	    		'selector' => 'ul',
	    	    		'classes' => 'list-orange',
	    	    	),
	    		),
	    	),
	    	array(
	    		'title'	=> 'Blockquotes',
	    		'items'	=> array(
	    	    	array(
	    	    		'title' => 'Border Blockquote',
	    	    		'selector' => 'blockquote',
	    	    		'classes' => 'border',
	    	    	),
	    	    	array(
	    	    		'title' => 'Quote Icon Blockquote',
	    	    		'selector' => 'blockquote',
	    	    		'classes' => 'icon',
	    	    	),
	    		),
	    	)
	    	
	    );
	    $settings['style_formats'] = json_encode( $style_formats );
	    return $settings;
	}
	add_filter( 'tiny_mce_before_init', 'ebor_mce_before_init' );
}

/**
 * Add additional styling options to TinyMCE
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_mce_buttons_2') )){
	function ebor_mce_buttons_2( $buttons ) {
	    array_unshift( $buttons, 'styleselect' );
	    return $buttons;
	}
	add_filter( 'mce_buttons_2', 'ebor_mce_buttons_2' );
}

if(!( function_exists('ebor_get_social_icons') )){
	function ebor_get_social_icons(){
		return array("et-500px","et-app-store","et-baidu","et-basecamp","et-behance","et-creative-cloud","et-dribbble","et-dropbox","et-evernote","et-facebook","et-flattr","et-flickr","et-foursquare","et-github","et-google","et-google-drive","et-google-hangouts","et-google-play","et-grooveshark","et-houzz","et-icloud","et-instagram","et-lastfm","et-linkedin","et-medium","et-mixi","et-onedrive","et-paypal","et-picasa","et-pinterest","et-qq","et-raft","et-rainbow","et-rdio","et-renren","et-scribd","et-sina-weibo","et-skype","et-slideshare","et-smashing","et-soundcloud","et-spotify","et-stumbleupon","et-swarm","et-tripadvisor","et-tumblr","et-twitter","et-vimeo","et-vine","et-vk","et-windows-store","et-xing","et-yelp","et-youko","et-youtube");
	}
}

if(!( function_exists('ebor_get_icons') )){
	function ebor_get_icons(){
		return array('si-alignment_align-all','si-alignment_align-all-1','si-alignment_align-justify-all','si-alignment_align-justify-center','si-alignment_align-justify-left','si-alignment_align-justify-right','si-alignment_bracket-symbols','si-alignment_column-row-horizontal','si-alignment_column-row-vertical','si-alignment_greater-less-than','si-alignment_grid-align','si-alignment_italic-text','si-alignment_last-place-symbol','si-alignment_letter','si-alignment_letter-align-1','si-alignment_no-border','si-alignment_pilcrow','si-alignment_quote-marks','si-alignment_text-align','si-alignment_text-format','si-alignment_text-list','si-alignment_text-magnet','si-alignment_text-media-list','si-alignment_window-align','si-alignment_window-align-center-top','si-alignment_window-align-half-left','si-alignment_window-align-left','si-alignment_window-align-left-top','si-alignment_window-align-quarter','si-alignment_window-align-quarter-top','si-alignment_window-align-right','si-alignment_window-align-thirds-top','si-pet_cat','si-pet_dog','si-pet_dog-bone-2','si-pet_dog-house','si-pet_empty-bowl','si-pet_fish','si-pet_orange-fish-bowl','si-pet_pet-food-bowl','si-pet_pet-grooming','si-pet_pet-heart-collar','si-pet_pet-injection','si-pet_pet-necklace','si-pet_pet-paw','si-pet_pet-tag','si-arrows_arrow-box-inside','si-arrows_arrow-box-outside','si-arrows_arrow-interruption','si-arrows_arrow-interruption-2','si-arrows_arrow-line-down','si-arrows_arrow-line-left','si-arrows_arrow-line-left-corner','si-arrows_arrow-line-left-top-corner','si-arrows_arrow-line-right','si-arrows_arrow-line-right-corner','si-arrows_arrow-line-right-top-corner','si-arrows_arrow-line-up','si-arrows_arrows-rectangle','si-arrows_bow-arrow-top-left','si-arrows_double-arrow-down','si-arrows_double-arrow-left','si-arrows_double-arrow-right','si-arrows_double-arrow-up','si-arrows_down-arrow','si-arrows_down-arrow-circle','si-arrows_down-arrow-closed','si-arrows_down-line-arrow-circle','si-arrows_download-arrow','si-arrows_expand-all-directions','si-arrows_expand-arrows-1','si-arrows_expand-arrows-2','si-arrows_expand-arrows-all-directions','si-arrows_expand-target','si-arrows_increasing-arrows','si-arrows_left-arrow','si-arrows_left-arrow-circle','si-arrows_left-arrow-closed','si-arrows_left-line-arrow-circle','si-arrows_left-right-align','si-arrows_minimize','si-arrows_minimize-arrows-3','si-arrows_minimize-line-arrows-3','si-arrows_refresh','si-arrows_refresh-3','si-arrows_right-arrow','si-arrows_right-arrow-circle','si-arrows_right-arrow-closed','si-arrows_right-line-arrow-circle','si-arrows_right-ways-2','si-arrows_up-arrow','si-arrows_up-arrow-circle','si-arrows_up-arrow-closed','si-arrows_up-line-arrow-circle','si-arrows_upload-arrow','si-badges_badge-2','si-badges_badge-8','si-badges_badge-9','si-badges_badge-shield','si-badges_badge-shield-2','si-badges_christianity','si-badges_fire-symbol','si-badges_medal-sign','si-badges_post-card','si-badges_ribbon-2','si-badges_ribbon-3','si-badges_ribbon-5','si-badges_water-symbol','si-building_appartment','si-building_appartment-2','si-building_appartment-3','si-building_castle','si-building_castle-tower','si-building_church','si-building_city-hall','si-building_country-home','si-building_country-home-2','si-building_country-warehouse','si-building_factory-2','si-building_forge','si-building_garage','si-building_government-building','si-building_guard-tower','si-building_home','si-building_home-2','si-building_home-add','si-building_home-discount-2','si-building_home-search-2','si-building_home-value-3','si-building_home-value-increase','si-building_hospital','si-building_hospital-2','si-building_large-factory','si-building_mosque','si-building_observatory','si-building_office-building-block','si-building_office-tower','si-building_official-building-3','si-building_official-building-4','si-building_pantheon','si-building_post-office','si-building_resident-block','si-building_resident-block-2','si-building_school','si-building_shop-board','si-building_small-home-2','si-building_small-shop','si-building_tower','si-building_university','si-building_university-2','si-building_windmill','si-cafe_asian-dish-rice','si-cafe_beer-bottle','si-cafe_beer-classic-glass','si-cafe_beer-glass','si-cafe_beer-glass-bottle','si-cafe_beer-soda-can','si-cafe_bottle-glass','si-cafe_bottle-opener','si-cafe_burger','si-cafe_candles','si-cafe_chairs-table','si-cafe_champagne','si-cafe_chef-hat','si-cafe_chicken-meat','si-cafe_coctail-drink','si-cafe_coffee-take-away-2','si-cafe_cup-2','si-cafe_dining-invoice','si-cafe_fork','si-cafe_fork-knife','si-cafe_fork-knife-sign','si-cafe_fork-spoon-knife','si-cafe_french-coffee','si-cafe_french-fries','si-cafe_glass-ice','si-cafe_hot-bowl','si-cafe_hot-coffee','si-cafe_hot-cup','si-cafe_ice-cream','si-cafe_ice-cream-glass','si-cafe_knife','si-cafe_margarita-drink','si-cafe_menu','si-cafe_mustard','si-cafe_mustard-ketchup','si-cafe_no-smoking','si-cafe_open-shop','si-cafe_pizza-slice','si-cafe_pot','si-cafe_restaurant-catalog','si-cafe_salt-pepper','si-cafe_sausage','si-cafe_serving-plate','si-cafe_serving-plate-hand','si-cafe_small-cake','si-cafe_smoking-allowed','si-cafe_soda-cup','si-cafe_spoon','si-cafe_take-away-coffee-4','si-cafe_take-away-drink-2','si-cafe_tea-bag','si-cafe_turkish-coffee','si-cafe_water-bottle','si-cafe_wine-glass','si-calendar_1st-month','si-calendar_alarm-bell-2','si-calendar_alarm-bell-active-2','si-calendar_alarm-bell-disable','si-calendar_alarm-clock-2','si-calendar_calendar-14','si-calendar_calendar-17','si-calendar_calendar-days','si-calendar_sand-clock-2','si-calendar_stopwatch','si-calendar_table-clock-alarm','si-calendar_trumpet','si-calendar_wall-clock-2','si-calendar_wrist-watch','si-camping_barbecue-grill-2','si-camping_bath-tissue','si-camping_binoculars','si-camping_binoculars-2','si-camping_camping-bag-2','si-camping_camping-car','si-camping_camping-tent','si-camping_compass','si-camping_direction','si-camping_fire','si-camping_first-aid-bag','si-camping_forest-camping','si-camping_kayak','si-camping_life-jacket','si-camping_life-preserver','si-camping_lighter','si-camping_liquid-bottle','si-camping_map','si-camping_map-route','si-camping_military-tent','si-camping_mountains','si-camping_parachute-2','si-camping_pines-nature','si-camping_place-in-map','si-camping_place-map','si-camping_road-sign','si-camping_shower','si-camping_skull-cap','si-camping_swiss-knife','si-camping_torch','si-camping_trailer','si-chat_chat','si-chat_chat-2','si-chat_chat-3','si-chat_chat-4','si-chat_chat-5','si-chat_chat-bubbles','si-chat_chat-bubbles-2','si-chat_chat-bubbles-3','si-chat_chat-bubbles-4','si-clothes_baby-hoodie','si-clothes_baseball-hat','si-clothes_belt','si-clothes_bra-underwear','si-clothes_cap-3','si-clothes_cap-4','si-clothes_dress-4','si-clothes_gentlemen-cap','si-clothes_gentlement-shoes','si-clothes_glasses','si-clothes_gloves','si-clothes_hanger','si-clothes_hat','si-clothes_heels','si-clothes_home-slippers','si-clothes_jacket','si-clothes_lady-bag-3','si-clothes_lady-shopping-bag','si-clothes_lady-wallet','si-clothes_lipstick','si-clothes_long-sleeve','si-clothes_pants','si-clothes_pants-3','si-clothes_ring','si-clothes_shirt','si-clothes_shirt-long-sleeve-polo','si-clothes_shirt-short-sleeve','si-clothes_shirt-short-sleeve-3','si-clothes_shoes-2','si-clothes_short-pants','si-clothes_short-pants-3','si-clothes_skirt-4','si-clothes_sleeveless-jacket','si-clothes_slippers','si-clothes_socks-2','si-clothes_sport-shoes','si-clothes_t-shirt','si-clothes_tie','si-clothes_tie-2','si-clothes_trendy-shoes','si-clothes_underwear','si-clothes_underwear-3','si-clothes_underwear-5','si-clothes_vest','si-clothes_wallet','si-clothes_wrist-watch-analog','si-construction_attention-sign','si-construction_caliper-2','si-construction_cone','si-construction_construction-tool-bag','si-construction_construction-truck','si-construction_construction-truck-2','si-construction_crane','si-construction_crane-2','si-construction_crane-3','si-construction_cutting-blade','si-construction_drill','si-construction_excavator','si-construction_hammer-2','si-construction_nail-screw','si-construction_oil-drilling','si-construction_paint-brush','si-construction_protection-helmet-glasses','si-construction_protection-jacket','si-construction_rotary-hammer','si-construction_ruler','si-construction_saw','si-construction_scraper','si-construction_scraper-3','si-construction_scraper-6','si-construction_screwdriver-5','si-construction_shovel','si-construction_small-scraper','si-construction_tiles','si-construction_trolley-loaded','si-construction_wall','si-construction_wood-cutting','si-construction_wrench-2','si-design_3d-cube','si-design_angle','si-design_brush-tool','si-design_bucket','si-design_cmyk','si-design_color-bucket-2','si-design_color-drop','si-design_color-palette','si-design_crop','si-design_crop-2','si-design_crop-ratio','si-design_ellipse-tool','si-design_eyedropper-tool','si-design_eyedropper-tool-2','si-design_image-crop','si-design_knife-tool','si-design_object-moving','si-design_paint-brush','si-design_paint-roller','si-design_pen-curves','si-design_pen-tool','si-design_pen-tool-3','si-design_pencil','si-design_pencil-2','si-design_print-mark','si-design_print-mark-2','si-design_quick-tool','si-design_rgb','si-design_rgb-colors','si-design_ruler-2','si-design_scissors-tool','si-design_selection-tool-2','si-design_shape-tools','si-design_shape-tools-2','si-design_sprey','si-design_stamp','si-design_text-format','si-design_text-tool','si-design_zoom-out-tool','si-design_zoom-tool','si-hardware-100','si-hardware_calculator-2','si-hardware_computer-laptop-connection','si-hardware_computer-phone-connection','si-hardware_desktop','si-hardware_ipad','si-hardware_iphone','si-hardware_laptop','si-hardware_laptop-connection','si-hardware_monitor','si-hardware_phone-buttons','si-hardware_phone-connection','si-hardware_printer','si-hardware_router','si-hardware_scanner','si-hardware_sd-card','si-hardware_ssd-disc','si-hardware_tablet','si-hardware_tablet-connection','si-hardware_usb-stick','si-hardware_usb-symbol','si-hardware_wired-keyboard','si-hardware_wired-mini-keyboard','si-hardware_wired-mouse','si-ecommerce_24h-support','si-ecommerce_barcode','si-ecommerce_bid-hammer','si-ecommerce_box-2','si-ecommerce_box-transport','si-ecommerce_cash-register','si-ecommerce_click-buy','si-ecommerce_credit-card','si-ecommerce_discount-badge','si-ecommerce_discount-coupon','si-ecommerce_discount-coupon-scissors','si-ecommerce_hot-products','si-ecommerce_money','si-ecommerce_money-calculator','si-ecommerce_new-products','si-ecommerce_pos','si-ecommerce_present','si-ecommerce_price-tag-4','si-ecommerce_product-search','si-ecommerce_product-tag','si-ecommerce_product-tag-3','si-ecommerce_product-tag-6','si-ecommerce_promotion','si-ecommerce_purchase-receipt','si-ecommerce_shield-confirm','si-ecommerce_shield-dollar','si-ecommerce_shop','si-ecommerce_shop-location','si-ecommerce_shopping-bag','si-ecommerce_shopping-bag-3','si-ecommerce_shopping-basket','si-ecommerce_shopping-basket-2','si-ecommerce_shopping-cart','si-ecommerce_smartphone-shopping','si-ecommerce_star-favorites','si-ecommerce_wallet','si-ecommerce_watchlist-eye','si-ecommerce_wishlist','si-electronics_blender','si-electronics_double-refrigator','si-electronics_espresso-machine','si-electronics_fridge','si-electronics_hair-dryer','si-electronics_hand-mixer','si-electronics_microwave','si-electronics_mixer','si-electronics_monitor','si-electronics_music-player','si-electronics_oven','si-electronics_oven-2','si-electronics_phone-fax','si-electronics_pocket-radio','si-electronics_satellite-dish','si-electronics_speakers','si-electronics_steamer','si-electronics_toaster','si-electronics_tv','si-electronics_vacuum','si-electronics_video-camera','si-electronics_washing-machine','si-electronics_water-boiler','si-energy_battery-power','si-energy_battery-power-2','si-energy_bio-symbol','si-energy_bulb-energy','si-energy_bulb-energy-3','si-energy_eco-lamp','si-energy_eco-symbol','si-energy_energy-5','si-energy_fire-energy','si-energy_high-voltage-grid','si-energy_leaf','si-energy_nuclear-energy','si-energy_oil-barrel','si-energy_oil-energy','si-energy_recycling','si-energy_sea-energy','si-energy_sun-energy','si-energy_sun-energy-2','si-energy_sun-panel-energy','si-energy_sun-solar-energy','si-energy_water-drops','si-energy_wind-turbine','si-files_download-fill-document','si-files_edit-document','si-files_file','si-files_file-list','si-files_search-document','si-files_text-file-2','si-finance_bitcoin','si-finance_business-bag','si-finance_charts-4','si-finance_coins','si-finance_contract','si-finance_decreasing-budget','si-finance_display-stats','si-finance_dollar-symbol','si-finance_economic-balance','si-finance_economic-growth','si-finance_euro-dollar-exchange','si-finance_euro-symbol-2','si-finance_finance-puzzle','si-finance_finance-target-2','si-finance_franc-symbol','si-finance_gold-bars-2','si-finance_idea','si-finance_increasing-budget','si-finance_insurance','si-finance_money-bag-2','si-finance_pie-chart','si-finance_pie-chart-2','si-finance_pound-symbol','si-finance_rouble-symbol','si-finance_statistics','si-finance_wallet','si-finance_yuan-symbol','si-folders_confirm-folders','si-folders_delete-folders','si-folders_download-folders','si-folders_locked-folders','si-folders_open-folder-2','si-folders_search-folders','si-folders_share-folders-3','si-folders_upload-folders','si-food_apple','si-food_avocado','si-food_bananas','si-food_bread-2','si-food_bread-slice','si-food_cabbage','si-food_cake','si-food_candy','si-food_carrot','si-food_cheese-slice','si-food_chef','si-food_cherries','si-food_chilli-pepper','si-food_chocolate','si-food_corn','si-food_cracked-egg','si-food_croissant','si-food_donut','si-food_eggplant','si-food_eggs','si-food_fish','si-food_fish-meat','si-food_fresh-fish','si-food_fried-egg','si-food_grain','si-food_grape','si-food_honey-3','si-food_hot-plate','si-food_ice-cream','si-food_lemon','si-food_lettuce-2','si-food_lollipop','si-food_lotus','si-food_milk-ration','si-food_mini-cake','si-food_mushroom-2','si-food_olives','si-food_onion','si-food_orange-slice','si-food_pear','si-food_peas','si-food_pepper','si-food_pineapple','si-food_pomegranate','si-food_potato','si-food_pumpkin','si-food_raw-meat','si-food_roasted-chicken','si-food_sausage','si-food_spring-onion','si-food_strawberry','si-food_tomato','si-food_watermelon-slice','si-food_zucchini','si-furniture_adjustable-lamp','si-furniture_bathtub','si-furniture_bedside','si-furniture_bedside-2','si-furniture_bin','si-furniture_book-shelf','si-furniture_camping-table','si-furniture_chair','si-furniture_chair-2','si-furniture_chair-table-lamp','si-furniture_classic-door','si-furniture_classic-table','si-furniture_closed-door-window','si-furniture_closet','si-furniture_coat-stand','si-furniture_cough','si-furniture_cough-3','si-furniture_desk','si-furniture_desk-computer','si-furniture_double-bed-picture','si-furniture_double-desk','si-furniture_ficture-light-1','si-furniture_floor-lamp','si-furniture_flower-pot','si-furniture_glass-table','si-furniture_hanger','si-furniture_kitchen-table-chairs','si-furniture_light-fixture','si-furniture_mirror','si-furniture_office-chair','si-furniture_single-bed-side','si-furniture_sink','si-furniture_small-book-shelf','si-furniture_small-tree-pot','si-furniture_stairs','si-furniture_stairway','si-furniture_stairway-2','si-furniture_stand','si-furniture_table-lamp','si-furniture_table-mirror','si-furniture_tv-stand','si-furniture_twin-bed','si-furniture_wall-picture','si-furniture_window','si-gambling_clover','si-gambling_clover-heart-pike-diamond','si-gambling_diamond','si-gambling_diamond-2','si-gambling_dice-3','si-gambling_dice-5','si-gambling_dice-6','si-gambling_dice-side-1','si-gambling_dice-side-2','si-gambling_dice-side-4','si-gambling_dollar-tips-2','si-gambling_heart','si-gambling_king','si-gambling_pike','si-gaming_bomb','si-gaming_classic-joystick','si-gaming_game-controller','si-gaming_game-disc','si-gaming_gaming-mouse','si-gaming_gun','si-gaming_handlet-console','si-gaming_headphone-mic','si-gaming_key','si-gaming_pac-man','si-gaming_pac-man-ghost','si-gaming_puzzle-piece','si-gaming_save-game','si-gaming_ship-wheel','si-gaming_tetris','si-gaming_wi-remote','si-gaming_wi-remote-2','si-gesture_3-fingers','si-gesture_hand-touch','si-gesture_middle-finger','si-gesture_stop','si-gesture_stop-finger-2','si-handcrafts_button-2','si-handcrafts_buttons','si-handcrafts_classic-chandlier','si-handcrafts_desk-lamp-4','si-handcrafts_e27-lamp','si-handcrafts_lamp-fixture','si-handcrafts_lamp-fixture-2','si-handcrafts_lamp-fixture-4','si-handcrafts_needle','si-handcrafts_paper-boat','si-handcrafts_pencil-ruler','si-handcrafts_pincushion','si-handcrafts_safety-pin','si-handcrafts_sewing-machine','si-handcrafts_spool','si-handcrafts_spool-needle','si-handcrafts_tape','si-health_gum-weight','si-health_gym-bike','si-health_gym-practice-2','si-health_gym-towel','si-health_heart-rate','si-health_increasing-performance','si-health_kg-weight','si-health_mp3-player','si-health_scale','si-health_stopwatch','si-health_sunset','si-health_swimming','si-health_tape-apple','si-health_treadmill','si-health_water-bottle-small','si-health_wristle','si-hotel_luggage','si-hotel_luggage-transport','si-hotel_room-key','si-hotel_room-tag','si-hotel_single-bed-human','si-hotel_single-bed-side','si-hotel_single-room','si-hotel_twin-bed','si-hotel_wallet-cash','si-hotel_wifi','si-hotel_wifi-signal','si-laundry_faucet','si-laundry_hand-cream','si-laundry_hand-wash','si-laundry_hand-washing','si-laundry_iron-max-temp-150','si-laundry_iron-steam-stand','si-laundry_machine-wash','si-logistics_big-box-handles','si-logistics_box-2','si-logistics_box-loading','si-logistics_box-loading-2','si-logistics_confirm-receipt','si-logistics_insert-box-2','si-logistics_non-waterproof','si-logistics_open-box-2','si-logistics_shipping','si-logistics_small-box','si-logistics_warehouse','si-logistics_wooden-box-3','si-logistics_wooden-box-4','si-mail_at-sign-2','si-mail_attachment-3','si-mail_email-attachment','si-mail_email-sent','si-mail_letter-mail-6','si-mail_mail','si-mail_mail-2','si-mail_mail-address','si-mail_mail-letter-5','si-mail_read-mail','si-mail_send-arrow','si-seo_campaign-stats','si-seo_cloud-computing','si-seo_cloud-seo','si-seo_hyperlink','si-seo_link-chain','si-seo_link-chain-2','si-seo_link-share','si-seo_marketing-idea','si-seo_marketing-idea-2','si-seo_optimization-growth-stats','si-seo_page-search-optimization','si-seo_search-glass','si-seo_seo-list','si-seo_seo-tags','si-seo_seo-target-2','si-seo_seo-techniques','si-seo_stats-chart-pie','si-seo_target','si-seo_target-audience-2','si-seo_video-marketing','si-seo_web-analytics','si-seo_web-page-settings','si-seo_website-code','si-repair_gauge','si-repair_gear-1','si-repair_gear-2','si-repair_gear-3','si-repair_gear-box','si-repair_gear-box-symbol','si-repair_gears','si-repair_lights-on','si-repair_lights-on-down','si-repair_lights-on-up','si-repair_mechanic','si-repair_safety-triangle','si-repair_steering-wheel','si-repair_wheel','si-medical_ambulance','si-medical_ambulance-siren','si-medical_bed','si-medical_confirmed-patient-history','si-medical_disabled-wheelchair','si-medical_doctor-agenta','si-medical_emergency-call','si-medical_eye','si-medical_female-sign','si-medical_first-aid-box','si-medical_health-rate','si-medical_health-records','si-medical_health-symbol','si-medical_heart','si-medical_heart-monitor','si-medical_hospital-helicopter-sign','si-medical_injection','si-medical_lungs','si-medical_male-sign','si-medical_microscope','si-medical_pill-bottle','si-medical_pills-2','si-medical_pulse','si-medical_scissors','si-medical_sperm','si-medical_stethoscope','si-medical_teeth','si-medical_virus','si-music_add-button','si-music_audio-analysis','si-music_audio-chart','si-music_audio-chart-2','si-music_audio-knob','si-music_audio-settings','si-music_back-button','si-music_banjo','si-music_cloud-music','si-music_decrease-volume','si-music_drum','si-music_eject-button','si-music_flute','si-music_forward-button','si-music_full-volume','si-music_guitar','si-music_headphones','si-music_headphones-2','si-music_increase-volume','si-music_less-volume','si-music_mic-4','si-music_microphone-2','si-music_microphone-3','si-music_mid-volume','si-music_mpr-player-2','si-music_mute-speaker','si-music_mute-volume','si-music_no-audio','si-music_nore-5','si-music_note-3','si-music_old-cassete','si-music_old-music-player','si-music_pause-button','si-music_piano','si-music_play-button','si-music_remove-button','si-music_shuffle','si-music_shuffle-2','si-music_singer-microphone','si-music_song-favorites','si-music_sound-settings','si-network_antena-signal-3','si-network_cloud-confirm','si-network_cloud-download','si-network_cloud-signal','si-network_communication-hub','si-network_connected-servers','si-network_connected-servers-2','si-network_connection-route','si-network_connection-tree','si-network_database','si-network_desktop-connection','si-network_global-network','si-network_network-folders','si-network_network-signal-4','si-network_network-speed','si-network_wifi-signal','si-party_balloon','si-party_balloons','si-party_candies','si-party_christmas-ball','si-party_christmas-cake','si-party_christmas-cake-2','si-party_christmas-candle-2','si-party_christmas-cute-cap','si-party_christmas-mask','si-party_christmas-snowball','si-party_christmas-socks','si-party_christmas-star','si-party_christmas-tree','si-party_cookie-man','si-party_door-bell','si-party_firework-4','si-party_firework-stars','si-party_holding-star','si-party_hot-serving-plate','si-party_present-gift','si-party_santa-claus-hat','si-party_ski-boots','si-party_snowflake','si-party_snowman','si-party_wax-candle','si-phone_app-store-icon','si-phone_bluetooth','si-phone_call-signal','si-phone_drop-call','si-phone_iphone','si-phone_phone-gps','si-phone_phone-ringing','si-photo_aperture','si-photo_camera','si-photo_cloudy-white-balance','si-photo_contrast','si-photo_curves','si-photo_diffuser-umbrella','si-photo_dslr','si-photo_dslr-lens','si-photo_film','si-photo_flash-on','si-photo_focus-infinity','si-photo_focus-point','si-photo_image-crop','si-photo_image-element','si-photo_image-files','si-photo_image-review','si-photo_landscape-picture','si-photo_magic-tools','si-photo_photo','si-photo_pincushion-distortion','si-photo_red-eye','si-photo_rgb-colors','si-photo_rule-thirds','si-photo_screen-focusing','si-photo_sd-card','si-education_abc-cubes','si-education_academic-cap-2','si-education_arithmetics','si-education_atom','si-education_big-bang-2','si-education_bio-hazard','si-education_book','si-education_book-2','si-education_book-3','si-education_calculator-2','si-education_chemistry-bottles','si-education_chemistry-elements','si-education_chemistry-glass','si-education_compass','si-education_dna','si-education_dna-2','si-education_earth-stand','si-education_earth-symbol','si-education_experiment','si-education_fibonacci-sequence','si-education_human-skull','si-education_identical','si-education_infinity','si-education_magnet','si-education_matter','si-education_matter-connection','si-education_minus','si-education_mouse-experiment','si-education_multiply','si-education_not-equal','si-education_note-sticker','si-education_notebook-2','si-education_oval-ruler','si-education_p-letter','si-education_panet-stars-3','si-education_pen-stylus','si-education_pencil','si-education_pencil-eraser','si-education_physic-elements','si-education_physics-gravity','si-education_planet-orbit','si-education_planet-orbit-2','si-education_plantes-orbit','si-education_plus','si-education_presentation-board','si-education_professor-bag','si-education_ruler','si-education_school-degree','si-education_science-book','si-education_science-document','si-education_science-microscope','si-education_search-research','si-education_square-root','si-education_students-class','si-education_sum','si-education_telescope','si-education_tie','si-education_transformer','si-education_triangle-ruler','si-education_university','si-education_virus-elements','si-education_virus-microscope-2','si-education_x-y-location','si-security_add-shield','si-security_confirm-shield','si-security_digital-numbers','si-security_enter-pin','si-security_eye-detection','si-security_fence','si-security_fingerprint','si-security_firewall','si-security_keylock','si-security_keylock-2','si-security_lockpad','si-security_lockpad-hole','si-security_pin-input','si-security_remove-shield','si-security_safety-wall','si-security_sheriff-medal','si-security_shield-cross','si-security_shield-star','si-security_shield-stripes','si-security_siren-alarm','si-spa_bamboo','si-spa_candles-2','si-spa_clean-brush','si-spa_comb','si-spa_cream','si-spa_eye-cream','si-spa_eye-makeup','si-spa_face-brush','si-spa_face-brush-2','si-spa_hand-cream','si-spa_hand-mirror-2','si-spa_lipstick','si-spa_makeup-brush-set','si-spa_massage-oil','si-spa_massage-oil-2','si-spa_mortar-pestle','si-spa_nail-polish','si-spa_perfume','si-spa_razor','si-spa_scissors','si-spa_shower','si-spa_small-candles','si-spa_spa-flower','si-spa_spa-oil','si-spa_spa-sign','si-spa_stones','si-spa_sunbed','si-spa_swim-pool','si-spa_table-mirror','si-spa_yin-yang','si-space_small-spaceship','si-space_space-dish','si-space_spaceship-takeoff','si-space_telescope','si-space_universe','si-sports_baseball','si-sports_baseball-ball','si-sports_baseball-stick-ball','si-sports_basketball-2','si-sports_bicycle','si-sports_billiard-8-ball','si-sports_billiard-balls','si-sports_boat','si-sports_bowling-ball-pin','si-sports_football-ball','si-sports_golf-ball-3','si-sports_hockey-ball','si-sports_hockey-sticks','si-sports_medal','si-sports_medal-2','si-sports_ping-pong','si-sports_podium','si-sports_roller-skates','si-sports_rugby','si-sports_rugby-helmet','si-sports_sport-flag','si-sports_stopwatch','si-sports_swimming-equipment','si-sports_target','si-sports_tennis-ball','si-sports_tennis-baseball','si-sports_ticket','si-sports_trophy','si-sports_trophy-2','si-sports_volleyball','si-sports_whistle','si-sports_wight-lifting-3','si-transport_air-balloon-2','si-transport_ambulance','si-transport_battery','si-transport_bicycle','si-transport_bus','si-transport_camp-car','si-transport_car','si-transport_cargo-plane','si-transport_city-train','si-transport_cruise-ship','si-transport_double-decker','si-transport_electric-bus','si-transport_fast-train','si-transport_fuel-station','si-transport_helicopter','si-transport_mini-bus','si-transport_pickup','si-transport_plane-face','si-transport_plane-symbol-2','si-transport_ship-anchor','si-transport_ship-boat','si-transport_ship-sea','si-transport_small-bike','si-transport_taxi','si-transport_taxi-2','si-transport_tractor','si-transport_traffic-barricade','si-transport_traffic-cone','si-transport_traffic-light','si-transport_traffic-triangle','si-transport_train-tunnel','si-transport_tram','si-transport_trolley','si-transport_trolley-box','si-transport_truck','si-ui_apps-home','si-ui_automatic','si-ui_delete-x','si-ui_edit','si-ui_edit-profile','si-ui_lockpad-6','si-ui_mail-message','si-ui_minus-2','si-ui_on-off','si-ui_on-off-2','si-ui_options','si-ui_plus','si-ui_profile-card','si-ui_search','si-ui_search-2','si-ui_settings','si-ui_settings-3','si-ui_settings-gear','si-ui_share','si-ui_star','si-ui_trash-bin','si-ui_user-3','si-ui_users','si-ui_window-stack','si-weather_celsius','si-weather_cloud','si-weather_cloud-droplet','si-weather_cloud-rain','si-weather_cloud-rain-1','si-weather_cloud-rain-2','si-weather_cloud-rain-snow','si-weather_cloud-snowflafes','si-weather_clouds','si-weather_cloudy-night','si-weather_cloudy-rain','si-weather_cloudy-rain-4','si-weather_cloudy-shower','si-weather_cloudy-snow','si-weather_cloudy-thunderbolt','si-weather_fahrenheit','si-weather_freeze','si-weather_hot-temperature','si-weather_humidity-percentage','si-weather_moon','si-weather_moon-stars','si-weather_night-snow','si-weather_rainbow','si-weather_rainy-night','si-weather_rainy-night-4','si-weather_rainy-night-shower','si-weather_rainy-night-thunderbolt','si-weather_sea-waves','si-weather_snowflake','si-weather_sun','si-weather_sun-cloud','si-weather_temperature','si-weather_thunderbolt-3','si-weather_thunderbolt-night','si-weather_umbrealla','si-weather_weather-warning','si-weather_wind-meter','si-weather_winds','si-weather_winds-rain','si-love_balloons','si-love_bible','si-love_bottle-glass','si-love_bow-tie','si-love_bow-tie-2','si-love_camera-filming','si-love_champagne','si-love_church','si-love_classic-piano','si-love_decoration','si-love_diamond','si-love_fell-in-love','si-love_heart-lockpad','si-love_heart-necklace','si-love_heart-necklace-2','si-love_hearts','si-love_love-bow','si-love_love-message','si-love_love-rainbow','si-love_lovely-bear','si-love_male-female','si-love_male-female-symbols','si-love_outdoor-wedding','si-love_photos','si-love_present-3','si-love_read-love-message','si-love_search-love','si-love_special-dish','si-love_tie','si-love_valentine-cake','si-love_wedding-cake','si-love_wedding-dress','si-love_wedding-invitation','si-love_wedding-list','si-love_wedding-present','si-love_wedding-ring','si-love_wedding-rings','si-love_wedding-shopping','si-love_wedding-trip-bag','et-add-to-list','et-add-user','et-address','et-adjust','et-air','et-aircraft','et-aircraft-landing','et-aircraft-take-off','et-align-bottom','et-align-horizontal-middle','et-align-left','et-align-right','et-align-top','et-align-vertical-middle','et-app-store','et-archive','et-area-graph','et-arrow-bold-down','et-arrow-bold-left','et-arrow-bold-right','et-arrow-bold-up','et-arrow-down','et-arrow-left','et-arrow-long-down','et-arrow-long-left','et-arrow-long-right','et-arrow-long-up','et-arrow-right','et-arrow-up','et-arrow-with-circle-down','et-arrow-with-circle-left','et-arrow-with-circle-right','et-arrow-with-circle-up','et-attachment','et-awareness-ribbon','et-back','et-back-in-time','et-baidu','et-bar-graph','et-basecamp','et-battery','et-beamed-note','et-behance','et-bell','et-blackboard','et-block','et-book','et-bookmark','et-bookmarks','et-bowl','et-box','et-briefcase','et-browser','et-brush','et-bucket','et-bug','et-cake','et-calculator','et-calendar','et-camera','et-ccw','et-chat','et-check','et-chevron-down','et-chevron-left','et-chevron-right','et-chevron-small-down','et-chevron-small-left','et-chevron-small-right','et-chevron-small-up','et-chevron-thin-down','et-chevron-thin-left','et-chevron-thin-right','et-chevron-thin-up','et-chevron-up','et-chevron-with-circle-down','et-chevron-with-circle-left','et-chevron-with-circle-right','et-chevron-with-circle-up','et-circle','et-circle-with-cross','et-circle-with-minus','et-circle-with-plus','et-circular-graph','et-clapperboard','et-classic-computer','et-clipboard','et-clock','et-cloud','et-code','et-cog','et-colours','et-compass','et-controller-fast-backward','et-controller-fast-forward','et-controller-jump-to-start','et-controller-next','et-controller-paus','et-controller-play','et-controller-record','et-controller-stop','et-controller-volume','et-copy','et-creative-cloud','et-creative-commons','et-creative-commons-attribution','et-creative-commons-noderivs','et-creative-commons-noncommercial-eu','et-creative-commons-noncommercial-us','et-creative-commons-public-domain','et-creative-commons-remix','et-creative-commons-share','et-creative-commons-sharealike','et-credit','et-credit-card','et-crop','et-cross','et-cup','et-cw','et-cycle','et-database','et-dial-pad','et-direction','et-document','et-document-landscape','et-documents','et-dot-single','et-dots-three-horizontal','et-dots-three-vertical','et-dots-two-horizontal','et-dots-two-vertical','et-download','et-dribbble','et-dribbble-with-circle','et-drink','et-drive','et-drop','et-dropbox','et-edit','et-email','et-emoji-flirt','et-emoji-happy','et-emoji-neutral','et-emoji-sad','et-erase','et-eraser','et-evernote','et-export','et-eye','et-eye-with-line','et-facebook','et-facebook-with-circle','et-feather','et-fingerprint','et-flag','et-flash','et-flashlight','et-flat-brush','et-flattr','et-flickr','et-flickr-with-circle','et-flow-branch','et-flow-cascade','et-flow-line','et-flow-parallel','et-flow-tree','et-flower','et-folder','et-folder-images','et-folder-music','et-folder-video','et-forward','et-foursquare','et-funnel','et-game-controller','et-gauge','et-github','et-github-with-circle','et-globe','et-google','et-google-drive','et-google-hangouts','et-google-play','et-google-with-circle','et-graduation-cap','et-grid','et-grooveshark','et-hair-cross','et-hand','et-heart','et-heart-outlined','et-help','et-help-with-circle','et-home','et-hour-glass','et-houzz','et-icloud','et-image','et-image-inverted','et-images','et-inbox','et-infinity','et-info','et-info-with-circle','et-instagram','et-instagram-with-circle','et-install','et-key','et-keyboard','et-lab-flask','et-landline','et-language','et-laptop','et-lastfm','et-lastfm-with-circle','et-layers','et-leaf','et-level-down','et-level-up','et-lifebuoy','et-light-bulb','et-light-down','et-light-up','et-line-graph','et-link','et-linkedin','et-linkedin-with-circle','et-list','et-location','et-location-pin','et-lock','et-lock-open','et-log-out','et-login','et-loop','et-magnet','et-magnifying-glass','et-mail','et-mail-with-circle','et-man','et-map','et-mask','et-medal','et-medium','et-medium-with-circle','et-megaphone','et-menu','et-merge','et-message','et-mic','et-minus','et-mixi','et-mobile','et-modern-mic','et-moon','et-mouse','et-mouse-pointer','et-music','et-network','et-new','et-new-message','et-news','et-newsletter','et-note','et-notification','et-notifications-off','et-old-mobile','et-old-phone','et-onedrive','et-open-book','et-palette','et-paper-plane','et-paypal','et-pencil','et-phone','et-picasa','et-pie-chart','et-pin','et-pinterest','et-pinterest-with-circle','et-plus','et-popup','et-power-plug','et-price-ribbon','et-price-tag','et-print','et-progress-empty','et-progress-full','et-progress-one','et-progress-two','et-publish','et-px','et-px-with-circle','et-qq','et-qq-with-circle','et-quote','et-radio','et-raft','et-raft-with-circle','et-rainbow','et-rdio','et-rdio-with-circle','et-remove-user','et-renren','et-reply','et-reply-all','et-resize-100','et-resize-full-screen','et-retweet','et-rocket','et-round-brush','et-rss','et-ruler','et-save','et-scissors','et-scribd','et-select-arrows','et-share','et-share-alternative','et-share-alternitive','et-shareable','et-shield','et-shop','et-shopping-bag','et-shopping-basket','et-shopping-cart','et-shuffle','et-signal','et-sina-weibo','et-skype','et-skype-with-circle','et-slideshare','et-smashing','et-sound','et-sound-mix','et-sound-mute','et-soundcloud','et-sports-club','et-spotify','et-spotify-with-circle','et-spreadsheet','et-squared-cross','et-squared-minus','et-squared-plus','et-star','et-star-outlined','et-stopwatch','et-stumbleupon','et-stumbleupon-with-circle','et-suitcase','et-swap','et-swarm','et-sweden','et-switch','et-tablet','et-tablet-mobile-combo','et-tag','et-text','et-text-document','et-text-document-inverted','et-thermometer','et-thumbs-down','et-thumbs-up','et-thunder-cloud','et-ticket','et-time-slot','et-tools','et-traffic-cone','et-trash','et-tree','et-triangle-down','et-triangle-left','et-triangle-right','et-triangle-up','et-tripadvisor','et-trophy','et-tumblr','et-tumblr-with-circle','et-tv','et-twitter','et-twitter-with-circle','et-typing','et-uninstall','et-unread','et-untag','et-upload','et-upload-to-cloud','et-user','et-users','et-v-card','et-video','et-video-camera','et-vimeo','et-vimeo-with-circle','et-vine','et-vine-with-circle','et-vinyl','et-vk','et-vk-alternitive','et-vk-with-circle','et-voicemail','et-wallet','et-warning','et-water','et-windows-store','et-xing','et-xing-with-circle','et-yelp','et-youko','et-youko-with-circle','et-youtube','et-youtube-with-circle');
	}
}

if(!( function_exists('ebor_get_social_icons') )){
	function ebor_get_social_icons(){
		return array('et-behance','et-dribbble','et-dribbble-with-circle','et-facebook','et-facebook-with-circle','et-flickr','et-flickr-with-circle','et-github','et-github-with-circle','et-grooveshark','et-houzz','et-icloud','et-instagram','et-instagram-with-circle','et-lastfm','et-lastfm-with-circle','et-linkedin','et-linkedin-with-circle','et-medium','et-medium-with-circle','et-picasa','et-pinterest','et-rdio','et-rdio-with-circle','et-skype','et-skype-with-circle','et-soundcloud','et-spotify','et-spotify-with-circle','et-stumbleupon','et-stumbleupon-with-circle','et-tripadvisor','et-tumblr','et-tumblr-with-circle','et-twitter','et-twitter-with-circle','et-vimeo','et-vimeo-with-circle','et-vine','et-vine-with-circle','et-vk','et-vk-alternitive','et-vk-with-circle','et-windows-store','et-xing','et-xing-with-circle','et-yelp','et-youko','et-youko-with-circle','et-youtube','et-youtube-with-circle');
	}
}

/**
 * Custom Comment Markup for creatink
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_custom_comment') )){
	function ebor_custom_comment($comment, $args, $depth) { 
		$GLOBALS['comment'] = $comment; 
	?>
	
		<li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
		    <div class="message">
				
				<?php if( 'comment' == get_comment_type() ) : ?>
			    	<div class="user icon icon-round"><?php echo get_avatar( $comment->comment_author_email, 70 ); ?></div>
				<?php endif; ?>
				
			    <div class="message-inner">
			        <div class="info">
			          <?php printf('<h5>%s</h5>', get_comment_author_link()); ?>
			          <div class="meta">
			          	<span class="date"><?php echo get_comment_date(); ?></span>
			          	<span class="reply"><?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?></span>
			          </div>
			        </div>
					<div class="post-content"><?php echo wpautop( get_comment_text() ); ?></div>
			        <?php if ($comment->comment_approved == '0') : ?>
			        <p><em><?php esc_html_e('Your comment is awaiting moderation.', 'creatink') ?></em></p>
			        <?php endif; ?>
			    </div>
				
		    </div>
		
	<?php }
}