jQuery(document).ready(function() {
	'use strict';
	
	/*-----------------------------------------------------------------------------------*/
	/*	WORDPRESS STUFF
	/*-----------------------------------------------------------------------------------*/
	jQuery('select:not(.woocommerce-checkout select)').wrap('<label class="custom-select" />').parent().append('<span></span>');
	jQuery('input[type="radio"], input[type="checkbox"]').after('<span></span>');
	jQuery('.wpcf7-checkbox').addClass('checkbox');
	jQuery('.wpcf7-radio').addClass('radio');
	jQuery('p:empty').remove();
    /*-----------------------------------------------------------------------------------*/
    /*  CENTERED SPLIT HEADER
    /*-----------------------------------------------------------------------------------*/
    var theLiElements = jQuery('.navbar.center.center-split .nav > li'),
        liCount = theLiElements.length,
        liHalf = ( Math.round(liCount / 2) ) - 1;
        
        
    theLiElements.each(function(i){
        if( i <= liHalf ){
            //nothing   
        } else {
            jQuery(this).addClass('pull-right');
        }
    });
	/*-----------------------------------------------------------------------------------*/
    /*	STICKY HEADER
    /*-----------------------------------------------------------------------------------*/
	if (jQuery(".navbar").length) {
    	var options = {
	        offset: 350,
	        offsetSide: 'top',
	        classes: {
	            clone: 'banner--clone fixed',
	            stick: 'banner--stick',
	            unstick: 'banner--unstick'
	        },
	        onStick: function() {
	            jQuery(jQuery.SmartMenus.Bootstrap.init);
	        },
	        onUnstick: function() {
	            jQuery('.navbar .btn-group').removeClass('open');
	        }
	    };
	    var banner = new Headhesive('.navbar', options);
	}
    /*-----------------------------------------------------------------------------------*/
    /*	HAMBURGER MENU ICON
    /*-----------------------------------------------------------------------------------*/
    jQuery(".nav-bars").on( "click", function() {
        jQuery(".nav-bars").toggleClass("is-active");
    });
    /*-----------------------------------------------------------------------------------*/
	/*	DROPDOWN MENU
	/*-----------------------------------------------------------------------------------*/
    jQuery('.navbar .nav .btn-group .dropdown-menu').on('click', function(e) {
        e.stopPropagation();
    });	   
	/*-----------------------------------------------------------------------------------*/
	/*	SLICK
	/*-----------------------------------------------------------------------------------*/
	jQuery('.slick-wrapper').each(function(idx, item) {
		var carouselId = "carousel" + idx;
		this.id = carouselId;
		jQuery(this).find('.slick').slick({
			dots: true,
			infinite: true,
			adaptiveHeight: true,
			touchThreshold: 10,
			swipeToSlide: true,
			slide: "#" + carouselId + " .slick .item",
			appendArrows: "#" + carouselId + " .slick-nav",
			appendDots: "#" + carouselId + " .slick-nav",
			prevArrow: '<div class="slick-prev-wrapper"><span class="slick-prev"></span></div>',
			nextArrow: '<div class="slick-next-wrapper"><span class="slick-next"></span></div>',
			customPaging: function(slider, i) {
				return '';
			}
		});
	});	
	/*-----------------------------------------------------------------------------------*/
    /*	AOS
    /*-----------------------------------------------------------------------------------*/
	AOS.init({
        easing: 'ease-in-out-sine',
        duration: 1000,
        once: true
      });
	/*-----------------------------------------------------------------------------------*/
    /*	COCOEN
    /*-----------------------------------------------------------------------------------*/
	jQuery('.cocoen').cocoen();
	/*-----------------------------------------------------------------------------------*/
    /*	PLYR
    /*-----------------------------------------------------------------------------------*/
	plyr.setup('.js-player');
    /*-----------------------------------------------------------------------------------*/
    /*	PATTERN WRAPPER
    /*-----------------------------------------------------------------------------------*/
    jQuery(".pattern-wrapper").css('background-image', function () {
	    var bg = ('url(' + jQuery(this).data("image-src") + ')');
	    return bg;
	});
    /*-----------------------------------------------------------------------------------*/
    /*	COUNTDOWN
	/*-----------------------------------------------------------------------------------*/
	jQuery(".countdown").countdown();
    /*-----------------------------------------------------------------------------------*/
    /*	COUNTER
    /*-----------------------------------------------------------------------------------*/
    jQuery('.counter .value').counterUp({
        delay: 50,
        time: 1000
    });
    /*-----------------------------------------------------------------------------------*/
    /*	PROGRESSBAR
	/*-----------------------------------------------------------------------------------*/
    var $pcircle = jQuery('.progressbar.full-circle');
    var $psemi = jQuery('.progressbar.semi-circle');
    var $pline = jQuery('.progressbar.line');
    
    $pcircle.each(function(i) {
        var circle = new ProgressBar.Circle(this, {
            strokeWidth: 4,
            trailWidth: 4,
            duration: 2000,
            easing: 'easeInOut',
            step: function(state, circle, attachment) {
                circle.setText(Math.round(circle.value() * 100));
            }
        });
        
        var value = (jQuery(this).attr('data-value') / 100);
        $pcircle.waypoint(function() {
            circle.animate(value);
        }, {
            offset: "100%"
        })
    });
    $psemi.each(function(i) {
        var semi = new ProgressBar.SemiCircle(this, {
            strokeWidth: 4,
            trailWidth: 4,
            duration: 2000,
            easing: 'easeInOut',
            step: function(state, circle, attachment) {
                circle.setText(Math.round(circle.value() * 100));
            }
        });
        
        var value = (jQuery(this).attr('data-value') / 100);
        $psemi.waypoint(function() {
            semi.animate(value);
        }, {
            offset: "100%"
        })
    });
    $pline.each(function(i) {
        var line = new ProgressBar.Line(this, {
            strokeWidth: 3,
            trailWidth: 3,
            duration: 3000,
            easing: 'easeInOut',
            text: {
                style: {
                    color: 'inherit',
                    position: 'absolute',
                    right: '0',
                    top: '-30px',
                    padding: 0,
                    margin: 0,
                    transform: null
                },
                autoStyleContainer: false
            },
            step: function(state, line, attachment) {
                line.setText(Math.round(line.value() * 100) + ' %');
            }
        });
        var value = (jQuery(this).attr('data-value') / 100);
        $pline.waypoint(function() {
            line.animate(value);
        }, {
            offset: "100%"
        })
    });
    /*-----------------------------------------------------------------------------------*/
    /*	CIRCLE INFO BOX
    /*-----------------------------------------------------------------------------------*/
    jQuery("#dial1").s8CircleInfoBox({
	    autoSlide: false,
	    action: "click"
	});
	jQuery("#dial2").s8CircleInfoBox({
	    autoSlide: false,
	    action: "click"
	});
	/*-----------------------------------------------------------------------------------*/
    /*	IMAGE ICON HOVER
    /*-----------------------------------------------------------------------------------*/
    jQuery('.overlay').prepend('<span class="bg"></span>');
    /*-----------------------------------------------------------------------------------*/
    /*	TOOLTIP
    /*-----------------------------------------------------------------------------------*/
    jQuery('.has-tooltip').tooltip();
    jQuery('.has-popover').popover({
	    trigger: 'focus'
    });
    /*-----------------------------------------------------------------------------------*/
	/*	INCREMENT
	/*-----------------------------------------------------------------------------------*/
    jQuery('.qtyplus').on('click', function(e){
        e.preventDefault();
        var fieldName = jQuery(this).attr('field');
        var currentVal = parseInt(jQuery('input[name='+fieldName+']').val());
        if (!isNaN(currentVal)) {
            jQuery('input[name='+fieldName+']').val(currentVal + 1);
        } else {
            jQuery('input[name='+fieldName+']').val(0);
        }
    });
    jQuery(".qtyminus").on('click', function(e) {
        e.preventDefault();
        var fieldName = jQuery(this).attr('field');
        var currentVal = parseInt(jQuery('input[name='+fieldName+']').val());
        if (!isNaN(currentVal) && currentVal > 0) {
            jQuery('input[name='+fieldName+']').val(currentVal - 1);
        } else {
            jQuery('input[name='+fieldName+']').val(0);
        }
    }); 
    /*-----------------------------------------------------------------------------------*/
    /*	PRETTIFY
    /*-----------------------------------------------------------------------------------*/
    window.prettyPrint && prettyPrint();
    /*-----------------------------------------------------------------------------------*/
    /*	INSTAGRAM
    /*-----------------------------------------------------------------------------------*/
    var instagramFeed = new Instafeed({
        target: 'instafeed-widget',
        get: 'user',
        limit: 6,
        userId: 1215763826,
        accessToken: '1215763826.f1627ea.512d3a9b334a4c91ac2e83d4f4d9b291',
        resolution: 'low_resolution',
        template: '<div class="item col-xs-4 col-sm-6 col-md-4"><figure class="overlay overlay1"><a href="{{link}}" target="_blank"></a><img src="{{image}}" /><figcaption><i class="et-link from-top icon-xs"></i></figcaption></figure></div>',
        after: function() {
            jQuery('#instafeed-widget figure.overlay').prepend('<span class="bg"></span>');
        }
    });
    jQuery('#instafeed-widget').each(function() {
        instagramFeed.run();
    });
    /*-----------------------------------------------------------------------------------*/
    /*	LIGHTGALLERY
    /*-----------------------------------------------------------------------------------*/
    var $lg = jQuery('.light-gallery');
        $lg.lightGallery({
            thumbnail: false,
            selector: 'a.lightbox-this',
            download: false,
            autoplayControls: false,
            zoom: false,
            fullScreen: true,
            videoMaxWidth: '1000px',
            loop: false,
            hash: true,
            mousewheel: true,
            videojs: true
        });
    /*-----------------------------------------------------------------------------------*/
    /*	ISOTOPE BLOG GRID
	/*-----------------------------------------------------------------------------------*/
    var $bloggrid = jQuery('.blog .isotope');
    $bloggrid.isotope({
        itemSelector: '.item',
        percentPosition: true,
        transitionDuration: '0.7s',
        masonry: {
            columnWidth: $bloggrid.width() / 12
        },
        layoutMode: 'masonry'
    });
    jQuery(window).resize(function() {
        $bloggrid.isotope({
            masonry: {
                columnWidth: $bloggrid.width() / 12
            }
        });
    });
    jQuery(window).on("load", function() {
		$bloggrid.isotope({
            masonry: {
                columnWidth: $bloggrid.width() / 12
            }
        });
		jQuery(document).trigger("vc-full-width-row");
	});
	jQuery(document).on("vc-full-width-row", function(){
		$bloggrid.isotope({
		    masonry: {
		        columnWidth: $bloggrid.width() / 12
		    }
		});
	});
    $bloggrid.imagesLoaded(function() {
        $bloggrid.isotope('layout');
    });
    /*-----------------------------------------------------------------------------------*/
    /*	ISOTOPE PORTFOLIO GRID
    /*-----------------------------------------------------------------------------------*/
	function enableIsotope() {
	  var $portfoliogrid = jQuery('.portfolio .isotope');
	  jQuery('.portfolio .isotope-filter').each( function( i, buttonGroup ) {
	    var $buttonGroup = jQuery( buttonGroup );
	
	    var grid = $buttonGroup.data('target');
	    jQuery(grid).imagesLoaded( function() {
	      jQuery(grid).isotope({
	        itemSelector: '.item',
	        percentPosition: true,
	        transitionDuration: '0.7s',
	        masonry: {
	            columnWidth: $portfoliogrid.width() / 12
	        },
	        layoutMode: 'masonry'
	      })
	    });
	    jQuery(window).resize(function() {
	        $portfoliogrid.isotope({
	            masonry: {
	                columnWidth: $portfoliogrid.width() / 12
	            }
	        });
	    });
	    jQuery(window).on("load", function() {
			$portfoliogrid.isotope({
	            masonry: {
	                columnWidth: $portfoliogrid.width() / 12
	            }
	        });
		});
		jQuery(document).on("vc-full-width-row", function(){
			$portfoliogrid.isotope({
			    masonry: {
			        columnWidth: $portfoliogrid.width() / 12
			    }
			});
		});
	    $buttonGroup.on( 'click', '.button', function() {
	      var $this = jQuery( this );
	      var filterValue = $this.attr('data-filter');
	      jQuery(grid).isotope({ filter: filterValue })
	      $buttonGroup.find('.active').removeClass('active');
	      $this.addClass('active');
	    });
	  });
	
	};
	enableIsotope();
    /*-----------------------------------------------------------------------------------*/
    /*	FOTORAMA
	/*-----------------------------------------------------------------------------------*/
    jQuery('.fotorama').fotorama({
        spinner: {
            color: 'rgba(0, 0, 0, 0)'
        }
    });
    jQuery('.fotorama-item').append(' ');
    /*-----------------------------------------------------------------------------------*/
    /*	PAGE LOADING
    /*-----------------------------------------------------------------------------------*/
	jQuery('.page-loading').delay(350).fadeOut('slow');
    jQuery('.page-loading .status').fadeOut('slow');    
    /*-----------------------------------------------------------------------------------*/
    /*	GO TO TOP
    /*-----------------------------------------------------------------------------------*/
    jQuery.scrollUp({
        scrollName: 'scrollUp',
        // Element ID
        scrollDistance: 300,
        // Distance from top/bottom before showing element (px)
        scrollFrom: 'top',
        // 'top' or 'bottom'
        scrollSpeed: 300,
        // Speed back to top (ms)
        easingType: 'linear',
        // Scroll to top easing (see http://easings.net/)
        animation: 'fade',
        // Fade, slide, none
        animationInSpeed: 200,
        // Animation in speed (ms)
        animationOutSpeed: 200,
        // Animation out speed (ms)
        scrollText: '<span class="btn btn-square btn-rounded btn-icon"><i class="et-chevron-small-up"></i></span>',
        // Text for element, can contain HTML
        scrollTitle: false,
        // Set a custom <a> title if required. Defaults to scrollText
        scrollImg: false,
        // Set true to use image
        activeOverlay: false,
        // Set CSS color to display scrollUp active point, e.g '#00FFFF'
        zIndex: 1001 // Z-Index for the overlay
    });
    /*-----------------------------------------------------------------------------------*/
    /*	COLLAGEPLUS
    /*-----------------------------------------------------------------------------------*/
    collage();
    function collage() {
        jQuery('#collage-large').imagesLoaded(function(){
			jQuery('#collage-large').removeWhitespace().collagePlus({
			    'fadeSpeed': 5000,
			    'targetHeight': 350,
			    'direction': 'vertical',
			    'allowPartialLastRow': true
			});
		});
        jQuery('#collage-medium').imagesLoaded(function(){
			jQuery('#collage-medium').removeWhitespace().collagePlus({
			    'fadeSpeed': 5000,
			    'targetHeight': 300,
			    'direction': 'vertical',
			    'allowPartialLastRow': true
			});
		});
    };
    var resizeTimer = null;
    jQuery(window).on('resize', function() {
        jQuery('.collage .collage-image-wrapper').css("opacity", 0);
        if (resizeTimer) clearTimeout(resizeTimer);
        resizeTimer = setTimeout(collage, 200);
    }); 
    jQuery(document).on("vc-full-width-row", function(){
    	jQuery('.collage .collage-image-wrapper').css("opacity", 0);
    	if (resizeTimer) clearTimeout(resizeTimer);
    	resizeTimer = setTimeout(collage, 200);
    });
    /*-----------------------------------------------------------------------------------*/
    /*	ONEPAGE HEADER OFFSET
    /*-----------------------------------------------------------------------------------*/	
    var header_height = jQuery('.navbar:not(.banner--clone)').outerHeight();
    var shrinked_header_height = 64;
    var firstStyle = {
        'padding-top': '' + shrinked_header_height + 'px',
        'margin-top': '-' + shrinked_header_height + 'px'
    };
    jQuery('.onepage section').css(firstStyle);
    var secondStyle = {
        'padding-top': '' + header_height + 'px',
        'margin-top': '-' + header_height + 'px'
    };
    jQuery('.onepage section:first-of-type').css(secondStyle);
	/*-----------------------------------------------------------------------------------*/
    /*	ONEPAGE NAV LINKS
    /*-----------------------------------------------------------------------------------*/	
	var empty_a = jQuery('.navbar ul.navbar-nav a[href="#"]');	
	empty_a.on('click', function(e) {
	    e.preventDefault();
	});
    jQuery('.navbar .nav li a[href^="#"]:not(a[href="#"])').on('click', function() {
        jQuery('.navbar .navbar-collapse.in').collapse('hide');
        jQuery('.nav-bars').removeClass('is-active');
    });
    /*-----------------------------------------------------------------------------------*/
	/*	ONEPAGE SMOOTH SCROLL
	/*-----------------------------------------------------------------------------------*/	
	jQuery(function() {
	  setTimeout(function() {
	    if (location.hash) {
	      window.scrollTo(0, 0);
	      var target = location.hash.split('#');
	      smoothScrollTo(jQuery('#'+target[1]));
	    }
	  }, 1);  
	  jQuery('nav a[href^=#]:not([href=#])').on('click', function() {
	    if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
	      smoothScrollTo(jQuery(this.hash));
	      return false;
	    }
	  });  
	  function smoothScrollTo(target) {
	    var target = target.length ? target : jQuery('[name=' + this.hash.slice(1) +']');
	    
	    if (target.length) {
	      jQuery('html,body').animate({
	        scrollTop: target.offset().top - jQuery('nav.navbar').height()
	      }, 1500, 'easeInOutExpo');
	    }
	  }
	});  
	/*-----------------------------------------------------------------------------------*/
    /*	STYLE TOGGLE
    /*-----------------------------------------------------------------------------------*/
    jQuery('body.show-switcher').append('<div class="style-toggle-wrapper"><input class="dn" type="checkbox" id="dn"/><label class="style-toggle" for="dn"><span class="style-toggle-handler"></span></label></div>');
    jQuery('body.show-switcher .vc_section').addClass('light-wrapper wrapper');
    jQuery('.dn').on('click', function() {
	     jQuery('.wrapper').toggleClass('light-wrapper dark-wrapper inverse-text');
	});
});

jQuery(window).load(function(){
	"use strict";
	
	jQuery('.rev_slider').each(function(){
		
		var $this = jQuery(this);
		
		$this.on('revolution.slide.onchange', function(e, data) { 
			var $param = $this.find('li').eq(data.slideIndex - 1).attr('data-param1');
			if( '' == $param ){
				$param = 'light';
			}
			$this.removeClass('rs-nav-light rs-nav-dark').addClass( 'rs-nav-' + $param ); 
		});
			
	});
	
	jQuery(window).trigger('resize');
	
	if( typeof window.vcParallaxSkroll !== 'undefined' && false !== window.vcParallaxSkroll ){
		window.vcParallaxSkroll.refresh();
	}
	
	setTimeout(function(){
		jQuery(window).trigger('resize');
		if( typeof window.vcParallaxSkroll !== 'undefined' && false !== window.vcParallaxSkroll ){
			window.vcParallaxSkroll.refresh();
		}
	}, 500);
	
});
window.blockFotoramaData = true;