<?php 
	get_header(); 
	
	global $wp_query;
	$total_results = $wp_query->found_posts;
	$items = ( $total_results == '1' ) ? esc_html__(' item.','creatink') : esc_html__(' items.','creatink');
?>

<div class="wrapper gray-wrapper page-title-wrapper">
	<div class="container inner pt-40 pb-40 flex-it">
		
		<h1 class="page-title align-left mb-0">
			<?php 
				echo esc_html_e( 'Your search for ', 'creatink' ); 
				echo '"' . get_search_query() . '"';
				echo esc_html__(' found ' ,'creatink') . $total_results . $items;
			?>
		</h1>
		
		<div class="align-right text-right mb-0">
			<a href="<?php echo esc_url( get_permalink( get_option( 'page_for_posts' ) ) ); ?>" class="btn"><?php esc_html_e( 'Visit Our Blog', 'creatink' ); ?></a>
		</div>
		
	</div><!-- /.container --> 
</div>
  
 <?php
	get_template_part( 'inc/content-wrapper', 'open' );
	
	get_template_part( 'loop/loop-post', get_option( 'blog_layout', 'grid' ) );
	
	get_template_part( 'inc/content-wrapper', 'close' );
	
	get_footer();