<?php 
	$id          = get_the_ID(); 
	$src         = get_the_post_thumbnail_url($id, 'full');
	$post_number = $wp_query->current_post;
	$class       = false;
	
	if( 0 == $post_number || 8 == $post_number ){
		$class = 'width2 height2';
	} elseif( 2 == $post_number || 4 == $post_number || 7 == $post_number ){
		$class = 'height2';
	}
?>

<div id="portfolio-<?php echo esc_html($id); ?>" <?php post_class( $class . ' item grid-sizer ' . ebor_the_terms('portfolio_category', ' ', 'slug') ); ?>>

	<?php if( has_post_thumbnail() ) : ?>
		<figure class="overlay overlay1">
			<a href="<?php echo esc_url($src); ?>" data-sub-html="#caption<?php echo esc_attr($id); ?>" class="lightbox-this"></a>
			<?php the_post_thumbnail( 'ebor-grid' ); ?>
			<figcaption>
				<?php the_title('<h5 class="from-top">', '</h5>'); ?>
			</figcaption>
		</figure>
	<?php endif; ?>
	
	<?php the_title('<div id="caption'. $id .'" class="hidden"><h3>', '</h3></div>'); ?>
	
</div><!-- /.item -->