<?php 
	$prev_post = get_adjacent_post(false, '', true);
	$next_post = get_adjacent_post(false, '', false);
	
	if( empty($prev_post) && empty($next_post) ){
		return false;
	}
?>

<hr />

<div class="post-nav-wrapper">
	
	<?php if(!empty($prev_post)) : ?>
		<div class="post-nav prev">
			<div class="meta">
				<i class="et-chevron-small-left"></i>
				<?php esc_html_e('Previous Article', 'creatink'); ?>
			</div>
			<h4>
				<a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>"><?php echo esc_html($prev_post->post_title); ?></a>
			</h4>
		</div>
	<?php endif; ?>
	
	<?php if(!empty($next_post)) : ?>
		<div class="post-nav next">
			<div class="meta">
				<?php esc_html_e('Next Article', 'creatink'); ?>
				<i class="et-chevron-small-right"></i>
			</div>
			<h4>
				<a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><?php echo esc_html($next_post->post_title); ?></a>
			</h4>
		</div>
	<?php endif; ?>
	
</div><!-- /.post-nav -->