<?php 
	$prev_post = get_adjacent_post(false, '', true);
	$next_post = get_adjacent_post(false, '', false);
	
	if( empty($prev_post) && empty($next_post) ){
		return false;
	}
?>
	
<div class="wrapper light-wrapper navi-wrapper">
	<div class="container inner pt-60 pb-50">
	
		<div class="pull-left"> 
		
			<?php if(!empty($prev_post)) : ?>
				<a href="<?php echo esc_url(get_permalink($prev_post->ID)); ?>" class="btn btn-rounded btn-icon btn-icon-left">
					<i class="et-chevron-left"></i>
					<?php esc_html_e( 'Prev Project', 'creatink' ); ?>
				</a> 
			<?php endif; ?>
				
			<?php if(!empty($next_post)) : ?>
				<a href="<?php echo esc_url(get_permalink($next_post->ID)); ?>" class="btn btn-rounded btn-icon btn-icon-right">
					<?php esc_html_e( 'Next Project', 'creatink' ); ?>
					<i class="et-chevron-right"></i>
				</a>
			<?php endif; ?>
			
		</div>
		
		<div class="pull-right">
			<div class="btn-group share-button"> 
			
				<a href="#" class="btn btn-rounded btn-icon btn-icon-left btn-red dropdown-toggle" data-toggle="dropdown">
					<i class="et-heart"></i>
					<?php esc_html_e( 'Share', 'creatink' ); ?>
				</a>
				
				<ul class="dropdown-menu">
				
					<li>
						<a href="#" class="goodshare" data-type="fb">
							<i class="et-facebook"></i>
							<?php esc_html_e( 'Facebook', 'creatink' ); ?>
						</a>
					</li>
					
					<li>
						<a href="#" class="goodshare" data-type="tw"><i class="et-twitter"></i><?php esc_html_e( 'Twitter', 'creatink' ); ?></a>
					</li>
					
					<li>
						<a href="#" class="goodshare" data-type="pt"><i class="et-pinterest"></i><?php esc_html_e( 'Pinterest', 'creatink' ); ?></a>
					</li>
					
					<li>
						<a href="#" class="goodshare" data-type="gp"><i class="et-google"></i><?php esc_html_e( 'Google+', 'creatink' ); ?></a>
					</li>
					
					<li>
						<a href="#" class="goodshare" data-type="tm"><i class="et-tumblr"></i><?php esc_html_e( 'Tumblr', 'creatink' ); ?></a>
					</li>
					
				</ul><!-- /.dropdown-menu --> 
				
			</div><!-- /.btn-group --> 
		</div><!-- /.pull-right --> 
	
	</div><!-- /.container --> 
</div><!-- /.light-wrapper --> 