<?php 
	$cats = get_categories('taxonomy=portfolio_category'); 
	$align = get_option( 'portfolio_filter_align', 'text-center' );
	
	if( isset( $wp_query->filter_alignment ) ){
		$align = $wp_query->filter_alignment;
	}
?>

<div class="isotope-filter button-group <?php echo esc_attr($align); ?>" data-target=".grid-1">
	<ul>
		<li>
			<a class="button active" data-filter="*"><?php esc_html_e( 'All', 'creatink' ); ?></a>
		</li>
		<?php
			if(is_array($cats)){
				foreach($cats as $cat){
					echo '<li><a data-filter=".'. esc_attr($cat->slug) .'" class="button"> '. $cat->name .' </a></li>';
				}
			}
		?>
	</ul>
</div>

<div class="clearfix"></div>