<?php 
	$header_images = get_post_meta($post->ID, '_ebor_gallery_images', 1); 
	if( is_array($header_images) ) :
?>

<div class="blog grid-view text-center">
	<div class="tiles tiles-m">
		<div class="isotope row light-gallery">
			<?php 
				foreach( $header_images as $id => $content ){
					
					$src  = wp_get_attachment_image_src( $id, 'full' );
					
					echo '
						<div class="item grid-sizer col-sm-6 col-md-4 web">
							
							<figure class="overlay overlay1">
								<a href="'. esc_url( $src[0] ) .'" data-sub-html="#caption'. get_the_ID() .'" class="lightbox-this"></a>
								'. wp_get_attachment_image( $id, 'large' ) .'
								<figcaption>
									<h5 class="from-top mb-0">'. esc_html__( 'View Larger', 'creatink' ) .'</h5>
								</figcaption>
							</figure>
							
							<div id="caption'. get_the_ID() .'" class="hidden">
								<h3>Project Title</h3>
								<p>Some description of the item</p>
							</div>
							
						</div>
					';
					
				}
			?>
		</div><!--/.row -->
	</div><!--/.tiles -->
</div>

<?php endif;