<?php
	$sub_header_email = get_option( 'sub_header_email', 'first.last@email.com' );
	$sub_header_telephone = get_option( 'sub_header_email', '+00 (123) 456 78 90' );
?>

<div class="top-bar gray-wrapper">
	<div class="container flex-it">
		
		<div class="align-left">
			<ul class="icon-list list-inline mb-0">
				<?php if($sub_header_email) : ?>
				<li>
					<i class="et-mail"></i>
					<a href="mailto:first.last@email.com" class="nocolor"><?php echo wp_kses_post($sub_header_email); ?></a>
				</li>
				<?php endif; ?>
				<?php if($sub_header_telephone) : ?>
				<li>
					<i class="et-old-phone"></i><?php echo wp_kses_post($sub_header_telephone); ?>
				</li>
				<?php endif; ?>
			</ul>
		</div>
		<!--/.align-left -->
		
		<div class="align-right text-right">
			<ul class="social social-bg social-s">
				<?php 
					for( $i = 1; $i < 6; $i++ ){
						if( $url = get_option("sub_header_social_url_$i") ) {
							echo '<li>
								      <a href="' . esc_url( $url ) . '" target="_blank">
									      <i class="' . esc_attr(get_option("sub_header_social_icon_$i")) . '"></i>
								      </a>
								  </li>';
						}
					} 
				?>
			</ul>
		</div><!--/.align-right -->
		
	</div><!--/.container -->
</div><!--/.top-bar -->