<?php 

/*
Register Fonts
*/
if(!( function_exists('ebor_fonts_url') )){
	function ebor_fonts_url(){
	    $font_url = '';

	    /*
	    	Translators: If there are characters in your language that are not supported
	   		by chosen font(s), translate this to 'off'. Do not translate into your own language.
	     */
	    if ( 'off' !== _x( 'on', 'Google font: on or off', 'creatink' ) ) {
	        $font_url = add_query_arg( 'family', urlencode( str_replace('+', ' ', get_option('google_font_string','Rubik:300,300i,400,400i,500,500i,700,700i')) ), "//fonts.googleapis.com/css" );
	    }
	    return $font_url;
	}
}

/**
 * Ebor Load Scripts
 * Properly Enqueues Scripts & Styles for the theme
 * @since version 1.0
 * @author TommusRhodus
 */ 
if(!( function_exists('ebor_load_scripts') )){
	function ebor_load_scripts() {
		global $post;
		
		$theme_data = wp_get_theme();
		$version    = $theme_data->get( 'Version' );
			
		//Enqueue Styles
		$extension = ( class_exists('WPLessPlugin') ) ? '.less' : '.css';
		wp_enqueue_style( 'ebor-google-font', ebor_fonts_url(), array(), $version );
		wp_enqueue_style( 'bootstrap', EBOR_THEME_DIRECTORY . 'style/css/bootstrap.min.css', array(), $version );
		wp_enqueue_style( 'ebor-icons', EBOR_THEME_DIRECTORY . 'style/type/icons.css', array(), $version );	
		wp_enqueue_style( 'ebor-plugins', EBOR_THEME_DIRECTORY . 'style/css/plugins.css', array(), $version );	
		wp_enqueue_style( 'ebor-style', get_stylesheet_uri(), array(), '1.0.0' );
		
		//Enqueue Scripts
		wp_enqueue_script( 'bootstrap', EBOR_THEME_DIRECTORY . 'style/js/bootstrap.min.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-aos', EBOR_THEME_DIRECTORY . 'style/js/aos.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-circleinfo', EBOR_THEME_DIRECTORY . 'style/js/circleinfo.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-cocoen', EBOR_THEME_DIRECTORY . 'style/js/cocoen.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-collage', EBOR_THEME_DIRECTORY . 'style/js/collage.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-countdown', EBOR_THEME_DIRECTORY . 'style/js/countdown.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-counterup', EBOR_THEME_DIRECTORY . 'style/js/counterup.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-easing', EBOR_THEME_DIRECTORY . 'style/js/easing.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-flickr', EBOR_THEME_DIRECTORY . 'style/js/flickr.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-fotorama', EBOR_THEME_DIRECTORY . 'style/js/fotorama.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-goodshare', EBOR_THEME_DIRECTORY . 'style/js/goodshare.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-gtt', EBOR_THEME_DIRECTORY . 'style/js/gtt.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'imagesloaded', EBOR_THEME_DIRECTORY . 'style/js/imagesloaded.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-instafeed', EBOR_THEME_DIRECTORY . 'style/js/instafeed.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'isotope', EBOR_THEME_DIRECTORY . 'style/js/isotope.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-jribbble', EBOR_THEME_DIRECTORY . 'style/js/jribbble.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-lightgallery', EBOR_THEME_DIRECTORY . 'style/js/lightgallery.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-mousewheel', EBOR_THEME_DIRECTORY . 'style/js/mousewheel.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-picturefill', EBOR_THEME_DIRECTORY . 'style/js/picturefill.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-plyr', EBOR_THEME_DIRECTORY . 'style/js/plyr.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-prettify', EBOR_THEME_DIRECTORY . 'style/js/prettify.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-progressbar', EBOR_THEME_DIRECTORY . 'style/js/progressbar.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-slick', EBOR_THEME_DIRECTORY . 'style/js/slick.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-smartmenus', EBOR_THEME_DIRECTORY . 'style/js/smartmenus.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-stickyheader', EBOR_THEME_DIRECTORY . 'style/js/stickyheader.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-typer', EBOR_THEME_DIRECTORY . 'style/js/typer.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-waypoints', EBOR_THEME_DIRECTORY . 'style/js/waypoints.js', array('jquery'), $version, true  );
		wp_enqueue_script( 'ebor-scripts', EBOR_THEME_DIRECTORY . 'style/js/scripts.js', array('jquery'), $version, true  );
		
		//Enqueue Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		
		$cats_css = false;
		
		$cats = get_categories('hide_empty=0');
		foreach( $cats as $cat ){
			$colour = get_option('cat_'. $cat->term_id .'_colour', '#70aed2');
			$cats_css .= '
				.cat'. $cat->term_id .' { background-color: '. $colour .' !important; }
			';
		}
		
		$primary_colour  = get_option( 'colour_primary', '#4c98c9' );
		$text_colour     = get_option( 'colour_text', '#707070' );
		$headings_colour = get_option( 'colour_headings', '#404040' );
		$meta_colour     = get_option( 'colour_meta', '#aaaaaa' );
		$primary_rgb     = ebor_hex2rgb($primary_colour);
		
		if( isset($post->ID) && $override = get_post_meta($post->ID, '_ebor_colour_override', 1) ){
			$primary_colour = $override;
			$primary_rgb    = ebor_hex2rgb($primary_colour);
		}

		$image_footer_bg = get_option( 'image_footer_bg', '' );
		$image_footer_bottom_padding = get_option( 'image_footer_bottom_padding', '369px' );
		
		$cats_css .= '
			
			.disc:after {
			    background: rgba('. $primary_rgb .', 0.7)
			}
			.overlay.color span.bg {
			    background: rgba('. $primary_rgb .', 0.8);
			}
			.overlay6.color:after,
			.overlay6.color:before {
			    background: rgba('. $primary_rgb .', 0.5);
			}
			.overlay8.color figcaption {
			    background: rgba('. $primary_rgb .', 0.8);
			}
			.page-loading .spinner,
			.tp-loader.spinner,
			.lg-outer .lg-item:after,
			.fotorama__wrap--css3 .fotorama__spinner {
			    border-left: 3px solid rgba('. $primary_rgb .', .15);
			    border-right: 3px solid rgba('. $primary_rgb .', .15);
			    border-bottom: 3px solid rgba('. $primary_rgb .', .15);
			    border-top: 3px solid rgba('. $primary_rgb .', .8);
			}
			#scrollUp .btn {
			    background: rgba('. $primary_rgb .', 0.8);
			}
			#scrollUp .btn:hover,
			#scrollUp .btn:focus,
			#scrollUp .btn:active,
			#scrollUp .btn.active {
			    background: rgba('. $primary_rgb .', 1);
			}
			a.hover:hover {
			    border-bottom: 1px solid '. $primary_colour .';
			}
			a {
			    color: '. $primary_colour .';
			}
			a:hover,
			a:focus {
			    text-decoration: none;
			    color: '. $primary_colour .';
			}
			.color-wrapper {
			    background: '. $primary_colour .';
			}
			.navbar .nav > li > a:hover,
			.navbar .nav > li.active > a,
			.navbar .navbar-other a.nav-link:hover {
			    background: none;
			    color: '. $primary_colour .'
			}
			.btn-group .dropdown-menu > li > a:hover,
			.btn-group .dropdown-menu > li > a:focus {
			    color: '. $primary_colour .';
			}
			.btn {
			    background: '. $primary_colour .';
			}
			.btn-border {
			    border: 2px solid '. $primary_colour .';
			    background: none;
			    color: '. $primary_colour .';
			}
			.btn:hover,
			.btn:focus,
			.btn:active,
			.btn.active {
			    background: #19aaca;
			}
			.btn-border:hover,
			.btn-border:focus,
			.btn-border:active,
			.btn-border.active {
			    border: 2px solid '. $primary_colour .';
			    background: '. $primary_colour .';
			}
			.fotorama__nav__frame.fotorama__nav__frame--thumb.fotorama__active:before {
			    border: 2px solid '. $primary_colour .';
			}
			.isotope-filter ul li a:hover,
			.isotope-filter ul li a.active {
			    color: '. $primary_colour .';
			}
			.size-picker span.active {
			    background: '. $primary_colour .';
			}
			.post-title a:hover,
			.more:hover,
			.meta a:hover {
			    color: '. $primary_colour .';
			}
			.meta.price {
			    color: '. $primary_colour .';
			}
			.post-nav-wrapper a:hover {
			    color: '. $primary_colour .';
			}
			.sidebox a:hover {
			    color: '. $primary_colour .'
			}
			#comments .info h5 a:hover {
			    color: '. $primary_colour .';
			}
			.image-list li a:hover {
			    color: '. $primary_colour .'
			}
			.icon-color,
			.text-color,
			.circle .progressbar-text {
			    color: '. $primary_colour .'
			}
			.icon-border {
			    border: 3px solid '. $primary_colour .';
			}
			.icon-bg {
			    background: '. $primary_colour .';
			}
			.nav-tabs > li > a:hover,
			.nav-tabs > li > a:hover *,
			.nav-tabs > li.active > a,
			.nav-tabs > li.active > a *,
			.nav-tabs > li.active > a:hover,
			.nav-tabs > li.active > a:focus {
			    color: '. $primary_colour .';
			}
			.nav-tabs-lined.nav-tabs-lined-bottom > li.active > a:after {
			    border-bottom: 1px solid '. $primary_colour .';
			}
			.nav-tabs-lined.nav-tabs-lined-top > li.active > a:after {
			    border-top: 1px solid '. $primary_colour .';
			}
			.panel-group-lined .panel-active .panel-heading .panel-title {
			    border-bottom: 1px solid '. $primary_colour .';
			    color: '. $primary_colour .';
			}
			.panel-group-lined .panel-title > a:active {
			    color: '. $primary_colour .';
			}
			.timeline.dot .timeline-icon:before {
				background: '. $primary_colour .';
			}
			.tooltip-inner {
			    background-color: '. $primary_colour .';
			}
			.tooltip.top .tooltip-arrow,
			.tooltip.top-left .tooltip-arrow,
			.tooltip.top-right .tooltip-arrow {
			    border-top-color: '. $primary_colour .'
			}
			.tooltip.right .tooltip-arrow {
			    border-right-color: '. $primary_colour .'
			}
			.tooltip.left .tooltip-arrow {
			    border-left-color: '. $primary_colour .'
			}
			.tooltip.bottom .tooltip-arrow,
			.tooltip.bottom-left .tooltip-arrow,
			.tooltip.bottom-right .tooltip-arrow {
			    border-bottom-color: '. $primary_colour .'
			}
			.pagination ul > li > a:hover,
			.pagination ul > .active > a span {
			    color: '. $primary_colour .'
			}
			textarea:focus,
			textarea.form-control:focus,
			input[type="text"]:focus,
			input[type="password"]:focus,
			input[type="datetime"]:focus,
			input[type="datetime-local"]:focus,
			input[type="date"]:focus,
			input[type="month"]:focus,
			input[type="time"]:focus,
			input[type="week"]:focus,
			input[type="number"]:focus,
			input[type="email"]:focus,
			input[type="url"]:focus,
			input[type="search"]:focus,
			input[type="tel"]:focus,
			input[type="color"]:focus,
			.uneditable-input:focus {
			    border-color: '. $primary_colour .'
			}
			input[type="radio"]:focus + span,
			input[type="checkbox"]:focus + span,
			input[type="radio"]:active + span,
			input[type="checkbox"]:active + span {
			    border-color: '. $primary_colour .'
			}
			input[type="radio"].error + span,
			input[type="checkbox"].error + span {
			    border-color: '. $primary_colour .'
			}
			input[type="radio"] + span::after {
			    background-color: '. $primary_colour .';
			    border-color: '. $primary_colour .';
			}
			input[type="radio"]:checked + span,
			input[type="checkbox"]:checked + span {
			    border: 1px solid '. $primary_colour .'
			}
			input[type="checkbox"] + span::after {
			    border: 0 solid '. $primary_colour .';
			}
			.bg-default {
			    background: '. $primary_colour .'
			}
			.progressbar.border {
				border-color: '. $primary_colour .';
			}
			.progressbar svg path:last-child {
			    stroke: '. $primary_colour .';
			}
			.page-loading .caption {
			    color: '. $primary_colour .';
			}
			.inverse-text.dark-wrapper .pagination:not(.boxed):not(.round) ul > li > a:hover,
			.inverse-text.dark-wrapper .pagination.round-simple ul > li > a:hover,
			.inverse-text a:not(.btn):not([class*="color-s-"]):hover,
			.inverse-text .isotope-filter ul li a:hover,
			.inverse-text .isotope-filter ul li a.active,
			.inverse-text .text-color {
			    color: '. $primary_colour .' !important;
			}
			.inverse-text .post-title a:hover,
			.inverse-text .bg-white .meta a:hover,
			.inverse-text .bg-white a.more:hover,
			.inverse-text .pagination:not(.boxed):not(.round) ul > li > a:hover,
			.inverse-text .pagination.round-simple ul > li > a:hover {
			    color: '. $primary_colour .' !important;
			}
			.inverse-text:not(.navbar):not(.nav-wrapper) textarea:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="text"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="password"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="datetime"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="datetime-local"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="date"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="month"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="time"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="week"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="number"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="email"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="url"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="search"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="tel"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="color"]:focus,
			.inverse-text:not(.navbar):not(.nav-wrapper) .uneditable-input:focus {
			    border-color: '. $primary_colour .';
			}
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="radio"]:checked + span,
			.inverse-text:not(.navbar):not(.nav-wrapper) input[type="checkbox"]:checked + span {
			    border-color: '. $primary_colour .'
			}
			@media (min-width: 992px) {
			    .navbar .navbar-nav > li > a.highlighted {
				    color: '. $primary_colour .'
				}
				.inverse-text .navbar-nav > li:not(.active) > a:not(.highlighted):hover,
				.inverse-text .navbar-nav > li > a:hover {
					color: '. $primary_colour .' !important
				}
			}
			footer.image-footer {
				background-image: url('. esc_url($image_footer_bg) .');
				padding-bottom: '. $image_footer_bottom_padding .';				
			}
			body,
			footer a,
			.map-info p,
			.icon p,
			label.custom-select,
			.checkbox label,
			.radio label,
			select,
			textarea,
			textarea.form-control,
			input[type="text"]:not(.qty),
			input[type="password"],
			input[type="datetime"],
			input[type="datetime-local"],
			input[type="date"],
			input[type="month"],
			input[type="time"],
			input[type="week"],
			input[type="number"],
			input[type="email"],
			input[type="url"],
			input[type="search"],
			input[type="tel"],
			input[type="color"],
			.uneditable-input,
			.search-form:before,
			.color-text,
			.inverse-text .bg-white select,
			.inverse-text .bg-white textarea,
			.inverse-text .bg-white textarea.form-control,
			.inverse-text .bg-white input[type="text"]:not(.qty),
			.inverse-text .bg-white input[type="password"],
			.inverse-text .bg-white input[type="datetime"],
			.inverse-text .bg-white input[type="datetime-local"],
			.inverse-text .bg-white input[type="date"],
			.inverse-text .bg-white input[type="month"],
			.inverse-text .bg-white input[type="time"],
			.inverse-text .bg-white input[type="week"],
			.inverse-text .bg-white input[type="number"],
			.inverse-text .bg-white input[type="email"],
			.inverse-text .bg-white input[type="url"],
			.inverse-text .bg-white input[type="search"],
			.inverse-text .bg-white input[type="tel"],
			.inverse-text .bg-white input[type="color"],
			.inverse-text .bg-white .uneditable-input {
			    color: '. $text_colour .';
			}
			.form-control::-webkit-input-placeholder {
			    color: '. $text_colour .';
			    font-weight: normal;
			}
			.form-control:-moz-placeholder {
			    color: '. $text_colour .';
			    font-weight: normal;
			    opacity: 1;
			}
			.form-control::-moz-placeholder {
			    color: '. $text_colour .';
			    font-weight: normal;
			    opacity: 1;
			}
			.form-control:-ms-input-placeholder {
			    color: '. $text_colour .';
			    font-weight: normal;
			}
			.inverse-text .bg-white p,
			.inverse-text .bg-white li,
			.inverse-text .panel-group-bg p,
			.inverse-text .bg-white table,
			.inverse-text .popover,
			.inverse-text .bg-white .color-text {
			    color: '. $text_colour .' !important;
			}
			h1,
			h2,
			h3,
			h4,
			h5,
			h6 {
			    color: '. $headings_colour .';
			}
			.text-muted,
			.meta,
			a.more,
			.meta span:after,
			.meta *,
			.meta.breadcrumbs a,
			.meta.price .quantity,
			.meta.price del {
			    color: '. $meta_colour .';
			}
			.inverse-text:not(.navbar):not(.nav-wrapper) select {
			    color: '. $meta_colour .';
			}
			.inverse-text .form-control::-webkit-input-placeholder {
			    color: '. $meta_colour .';
			}
			.inverse-text .form-control:-moz-placeholder {
			    color: '. $meta_colour .';
			}
			.inverse-text .form-control::-moz-placeholder {
			    color: '. $meta_colour .';
			}
			.inverse-text .form-control:-ms-input-placeholder {
			    color: '. $meta_colour .';
			}
			footer.dark-wrapper a {
				color: #fff;
			}
			.light-wrapper {
			    background: '. get_option( 'colour_light_wrapper', '#f6f7f8' ) .';
			}
			.dark-wrapper {
			    background: '. get_option( 'colour_dark_wrapper', '#2b2b2b' ) .';
			}
			footer.dark-wrapper,
			.navbar.dark-wrapper,
			.nav-wrapper.dark-wrapper,
			.navbar.narrow:not(.fixed) .nav-wrapper.dark-wrapper .container {
			    background: '. get_option( 'colour_footer_dark_wrapper', '#272727' ) .';
			}
			.sub-footer.dark-wrapper {
			    background: '. get_option( 'colour_subfooter_dark_wrapper', '#232323' ) .';
			}
		';
		
		wp_add_inline_style( 'ebor-style', $cats_css );
		
	}
	add_action('wp_enqueue_scripts', 'ebor_load_scripts', 110);
}

/**
 * Ebor Load Admin Scripts
 * Properly Enqueues Scripts & Styles for the theme
 * 
 * @since version 1.0
 * @author TommusRhodus
 */
if(!( function_exists('ebor_admin_load_scripts') )){
	function ebor_admin_load_scripts(){
		wp_enqueue_style( 'ebor-theme-admin-css', EBOR_THEME_DIRECTORY . 'admin/ebor-theme-admin.css' );
		wp_enqueue_style( 'ebor-icons', EBOR_THEME_DIRECTORY . 'style/type/icons.css' );	
		wp_enqueue_script( 'ebor-theme-admin-js', EBOR_THEME_DIRECTORY . 'admin/ebor-theme-admin.js', array('jquery'), false, true );
	}
	add_action('admin_enqueue_scripts', 'ebor_admin_load_scripts', 200);
}