<?php 

function ebor_set_transport($wp_customize){	
	
	//Single post meta
	$wp_customize->selective_refresh->add_partial( 'creatink_single_post_title', array(
	    'selector' => '.single .article__title h1'
	) );

}
add_action('customize_register', 'ebor_set_transport', 20 );


/**
 * Build theme options
 * Uses the Ebor_Options class found in the ebor-framework plugin
 * Panels are WP 4.0+!!!
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if( class_exists('Ebor_Options') ){
	
	$social_options = array_values(ebor_get_social_icons());
	$ebor_options = new Ebor_Options;
	$theme = wp_get_theme();
	$theme_name = $theme->get( 'Name' );
	$yesNo = array('yes' => 'Yes', 'no' => 'No');
	$header_options = ebor_get_header_options();
	$footer_layouts = ebor_get_footer_options();
	$blog_layouts = array_flip(ebor_get_blog_layouts());
	$portfolio_options = array_flip(ebor_get_portfolio_layouts());
	$shop_options = array_flip(ebor_get_shop_layouts());
	$single_portfolio_options = array_flip(ebor_get_single_portfolio_layouts());

	foreach( $social_options as $social_option ){
		$final_social_options[$social_option] = str_replace('sa-', '', $social_option);
	}

	//Category highlight colour selectors
	$cats = get_categories('hide_empty=0');
	foreach( $cats as $cat ){
		$ebor_options->add_setting('color', 'cat_'. $cat->term_id .'_colour', $cat->name . ' Category Colour', 'colors', '#4aa2d1', $cat->term_id + 100);
	}
	
	$ebor_options->add_panel( $theme_name . ': Header Settings', 215, 'All of the controls in this section directly relate to the header and logos of ' . $theme_name);
	
	//Header Settings
	$ebor_options->add_section('logo_settings_section', 'Logo Settings', 10, $theme_name . ': Header Settings');
	
	//Logo Options
	$ebor_options->add_setting('image', 'custom_logo', 'Logo', 'logo_settings_section', EBOR_THEME_DIRECTORY . 'style/images/logo.png', 5);
	$ebor_options->add_setting('image', 'custom_logo_retina', 'Retina Logo', 'logo_settings_section', EBOR_THEME_DIRECTORY . 'style/images/logo@2x.png' , 5);
	$ebor_options->add_setting('image', 'custom_logo_dark', 'Light Logo', 'logo_settings_section', EBOR_THEME_DIRECTORY . 'style/images/logo-light.png', 5);
	$ebor_options->add_setting('image', 'custom_logo_dark_retina', 'Retina Light Logo', 'logo_settings_section', EBOR_THEME_DIRECTORY . 'style/images/logo-light@2x.png', 5);

	$ebor_options->add_section('header_layout_section', 'Layout Settings', 10, $theme_name . ': Header Settings', '<strong>Please Note:</strong> Your choice here will not affect every page if you installed our demo data. Some of our installed demo data pages, specifically the homepages, have a header override set.');
	$ebor_options->add_setting('select', 'header_layout', 'Global Header Layout', 'header_layout_section', 'classic-light', 20, $header_options);
	$ebor_options->add_setting('select', 'show_header_search', 'Show search link header? (magnifying glass)', 'header_layout_section', 'yes', 40, $yesNo);
	$ebor_options->add_setting('select', 'show_header_cart', 'Show cart icon header?', 'header_layout_section', 'yes', 45, $yesNo);

	$ebor_options->add_section('top_bar_section', 'Sub Header Settings', 25, $theme_name . ': Header Settings');
	$ebor_options->add_setting('input', 'sub_header_email', 'Sub Header Email', 'top_bar_section', 'first.last@email.com', 5);
	$ebor_options->add_setting('input', 'sub_header_telephone', 'Sub Header Telephone', 'top_bar_section', '+00 (123) 456 78 90', 5);
	
	//header Icons
	for( $i = 1; $i < 6; $i++ ){
		$ebor_options->add_setting('select', 'sub_header_social_icon_' . $i, 'Sub Header Social Icon ' . $i, 'top_bar_section', 'none', 20 + $i + $i, $final_social_options);
		$ebor_options->add_setting('input', 'sub_header_social_url_' . $i, 'Sub Header Social URL ' . $i, 'top_bar_section', '', 21 + $i + $i);
	}

	//Team options
	$ebor_options->add_panel( $theme_name . ': Team Settings', 215, 'All of the controls in this section directly relate to team area of ' . $theme_name);
	$ebor_options->add_section('team_title_section', 'Team Options', 320, $theme_name . ': Team Settings');
	$ebor_options->add_setting('input', 'team_title', 'Team Title', 'team_title_section', 'Meet the Team', 10);
	$ebor_options->add_setting('textarea', 'team_subtitle', 'Team Subtitle', 'team_title_section', 'Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Nulla vitae elit libero, a pharetra augue.', 15);
	
	//Colours
	$ebor_options->add_setting('color', 'colour_text', 'Text Colour', 'colors', '#707070', 5);
	$ebor_options->add_setting('color', 'colour_headings', 'Headings Colour', 'colors', '#404040', 10);
	$ebor_options->add_setting('color', 'colour_primary', 'Highlight Colour', 'colors', '#4c98c9', 15);
	$ebor_options->add_setting('color', 'colour_meta', 'Meta Colour', 'colors', '#aaaaaa', 25);
	$ebor_options->add_setting('color', 'colour_light_wrapper', 'Light Wrapper Background Colour', 'colors', '#f6f7f8', 30);
	$ebor_options->add_setting('color', 'colour_dark_wrapper', 'Dark Wrapper Background Colour', 'colors', '#2b2b2b', 35);
	$ebor_options->add_setting('color', 'colour_footer_dark_wrapper', 'Dark Footer & Nav Background Colour', 'colors', '#272727', 40);
	$ebor_options->add_setting('color', 'colour_subfooter_dark_wrapper', 'Subfooter Background Colour', 'colors', '#232323', 45);

	/**
	 * All Portfolio Settings
	 */
	$ebor_options->add_panel( $theme_name . ': Portfolio Settings', 220, 'All of the controls in this section directly relate to the control of Portfolio items within ' . $theme_name);
	
	/**
	 * Portfolio Archive settings
	 */
	$ebor_options->add_section('portfolio_archive_section', 'Portfolio Archive Settings', 15, $theme_name . ': Portfolio Settings');
	$ebor_options->add_setting('select', 'portfolio_layout', 'Global Portfolio Layout', 'portfolio_archive_section', 'classic-grid', 20, $portfolio_options);

	$ebor_options->add_section('portfolio_archive_section', 'Portfolio Archive Settings', 15, $theme_name . ': Portfolio Settings');
	$ebor_options->add_setting('select', 'portfolio_layout', 'Global Portfolio Layout', 'portfolio_archive_section', 'classic-grid', 20, $portfolio_options);

	/**
	 * Portfolio single settings
	 */
	$ebor_options->add_section('portfolio_single_section', 'Portfolio Single Post Settings', 25, $theme_name . ': Portfolio Settings');
	$ebor_options->add_setting('select', 'single_portfolio_layout', 'Single Portfolio Layout', 'portfolio_single_section', 'content-left', 5, $single_portfolio_options);
	$ebor_options->add_setting('select', 'single_portfolio_related', 'Show related items?', 'portfolio_single_section', 'yes', 25, $yesNo);
	$ebor_options->add_setting('select', 'single_portfolio_nav', 'Show post navigation?', 'portfolio_single_section', 'yes', 25, $yesNo);
	
	//Blog Settings
	$ebor_options->add_panel( $theme_name . ': Blog Settings', 215, 'All of the controls in this section directly relate to blog area of ' . $theme_name);
	$ebor_options->add_section('blog_layout_section', 'Blog Layout', 310,  $theme_name . ': Blog Settings');
	$ebor_options->add_setting('select', 'blog_layout', 'Blog Archives Layout', 'blog_layout_section', 'grid-3', 10, $blog_layouts);
	
	$ebor_options->add_panel( $theme_name . ': Footer Settings', 245, 'All of the controls in this section directly relate to the control of footer design within ' . $theme_name);
	$ebor_options->add_section('footer_social_settings_section', 'Footer Social Settings', 20, $theme_name . ': Footer Settings');
	
	$ebor_options->add_section('footer_settings_section', 'Footer Settings', 30, $theme_name . ': Footer Settings');
	$ebor_options->add_setting('select', 'footer_layout', 'Global Footer Layout', 'footer_settings_section', 'widgets', 5, $footer_layouts);
	$ebor_options->add_setting('image', 'image_footer_bg', 'Image Footer Background', 'footer_settings_section', '', 10);
	$ebor_options->add_setting('input', 'image_footer_bottom_padding', 'Image Footer Padding', 'footer_settings_section', '369px', 11);
	
	//shop Settings
	$ebor_options->add_panel( $theme_name . ': Shop Settings', 215, 'All of the controls in this section directly relate to shop area of ' . $theme_name);
	$ebor_options->add_section('shop_layout_section', 'Shop Layout', 310,  $theme_name . ': Shop Settings');
	$ebor_options->add_setting('select', 'shop_layout', 'Shop Archives Layout', 'shop_layout_section', 'grid-3', 10, $shop_options);
	
	//Footer Icons
	for( $i = 1; $i < 6; $i++ ){
		$ebor_options->add_setting('select', 'footer_social_icon_' . $i, 'Footer Social Icon ' . $i, 'footer_social_settings_section', 'none', 20 + $i + $i, $final_social_options);
		$ebor_options->add_setting('input', 'footer_social_url_' . $i, 'Footer Social URL ' . $i, 'footer_social_settings_section', '', 21 + $i + $i);
	}
	
	$ebor_options->add_setting('textarea', 'footer_copyright', 'Copyright Message', 'footer_settings_section', '<a href="http://www.tommusrhodus.com">Creatink Premium WordPress Theme by TommusRhodus</a>', 20);
	
}