<?php 

/**
 * Build theme metaboxes
 * Uses the cmb metaboxes class found in the ebor framework plugin
 * More details here: https://github.com/WebDevStudios/Custom-Metaboxes-and-Fields-for-WordPress
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_custom_metaboxes') )){
	function ebor_custom_metaboxes( $meta_boxes ) {
		
		$prefix                    = '_ebor_';
		$social_options            = ebor_get_social_icons();
		$footer_options            = ebor_get_footer_options();
		$header_options            = ebor_get_header_options();
		$post_options              = array_flip(ebor_get_single_post_layouts());
		$portfolio_options         = array_flip(ebor_get_single_portfolio_layouts());
		$portfolio_content_options = array_flip(ebor_get_single_portfolio_content_layouts());
		
		foreach($social_options as $option){
			$new_social_options[$option] = str_replace('et-', '', $option);
		}
		
		$footer_overrides['none'] = 'Do Not Override Footer Option On This Page';
		foreach( $footer_options as $key => $value ){
			$footer_overrides[$key] = 'Override Footer: ' . $value; 	
		}
		
		$header_overrides['none'] = 'Do Not Override Header Option On This Page';
		foreach( $header_options as $key => $value ){
			$header_overrides[$key] = 'Override Header: ' . $value; 	
		}
		
		$post_overrides['none'] = 'Do Not Override Post Layout Option On This Post';
		foreach( $post_options as $key => $value ){
			$post_overrides[$key] = 'Override Post Layout: ' . $value; 	
		}
		
		$meta_boxes[] = array(
			'id' => 'portfolio_layout_metabox',
			'title' => esc_html__('Portfolio Item Layout Options', 'creatink'),
			'object_types' => array('portfolio'), // post type
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name' => 'Featured Content Type',
					'id' => $prefix . 'featured_content_type',
					'type' => 'select',
					'options' => $portfolio_content_options,
					'default' => 'slider-arrows',
					'description' => 'What will your featured content be?'
				),
				array(
					'name' => 'Featured Content Position',
					'id' => $prefix . 'portfolio_layout',
					'type' => 'select',
					'options' => $portfolio_options,
					'default' => 'content-left',
					'description' => 'Where will you show the featured content? Post content will be relative to this.'
				),
				array(
					'name' => esc_html__('Featured Content Images', 'creatink' ),
					'desc' => esc_html__('Min Height 550px, Max 1400px, Drag & Drop to Reorder', 'creatink' ),
					'id' => $prefix . 'gallery_images',
					'type' => 'file_list',
				),
				array(
					'name' => esc_html__('Video Featured Content oEmbed', 'creatink' ),
					'desc' => 'Enter a Youtube or Vimeo URL. Supports services listed <a href="http://codex.wordpress.org/Embeds" target="_blank">here</a>',
					'id'   => $prefix . 'the_oembed',
					'type' => 'oembed',
				),
				array(
				    'id'          => $prefix . 'meta_repeat_group',
				    'type'        => 'group',
				    'description' => esc_html__( 'Meta Titles & Descriptions', 'creatink' ),
				    'options'     => array(
				        'add_button'    => esc_html__( 'Add Another Entry', 'creatink' ),
				        'remove_button' => esc_html__( 'Remove Entry', 'creatink' ),
				        'sortable'      => true, // beta
				    ),
				    'fields'      => array(
						array(
							'name' => esc_html__('Additional Item Title', 'creatink'),
							'desc' => esc_html__("Title of your Additional Meta", 'creatink'),
							'id'   => $prefix . 'the_additional_title',
							'type' => 'text'
						),
						array(
							'name' => esc_html__('Additional Item Detail', 'creatink'),
							'desc' => esc_html__("Detail of your Additional Meta", 'creatink'),
							'id'   => $prefix . 'the_additional_detail',
							'type' => 'textarea_code'
						),
				    ),
				),
				array(
					'name' => esc_html__('Additional Content to Display Below Post Meta', 'creatink' ),
					'id'   => $prefix . 'meta_wysiwyg',
					'type' => 'wysiwyg',
				),
			)
		);
		
		/**
		 * Social Icons for Team Members
		 */
		$meta_boxes[] = array(
			'id' => 'social_metabox',
			'title' => esc_html__('Team Member Details', 'creatink'),
			'object_types' => array('team'), // post type
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name' => esc_html__('Job Title', 'creatink'),
					'desc' => '(Optional) Enter a Job Title for this Team Member',
					'id'   => $prefix . 'the_job_title',
					'type' => 'text',
				),
				array(
				    'id'          => $prefix . 'team_social_icons',
				    'type'        => 'group',
				    'options'     => array(
				        'add_button'    => esc_html__( 'Add Another Icon', 'creatink' ),
				        'remove_button' => esc_html__( 'Remove Icon', 'creatink' ),
				        'sortable'      => true
				    ),
				    'fields' => array(
						array(
							'name' => 'Social Icon',
							'desc' => 'What icon would you like for this team members first social profile?',
							'id' => $prefix . 'social_icon',
							'type' => 'select',
							'options' => $new_social_options
						),
						array(
							'name' => esc_html__('URL for Social Icon', 'creatink'),
							'desc' => esc_html__("Enter the URL for Social Icon 1 e.g www.google.com", 'creatink'),
							'id'   => $prefix . 'social_icon_url',
							'type' => 'text'
						),
				    ),
				),
			)
		);
		
		/**
		 * testimonial options
		 */
		$meta_boxes[] = array(
			'id' => 'testimonial_metabox',
			'title' => esc_html__('Testimonial URL', 'creatink'),
			'object_types' => array('testimonial'), // post type
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name' => esc_html__('Job Title', 'creatink'),
					'desc' => '(Optional) Enter a Job Title for this testimonial',
					'id'   => $prefix . 'the_job_title',
					'type' => 'text',
				),
			),
		);
		
		$custom_menus = array();
		$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
		if ( is_array( $menus ) && ! empty( $menus ) ) {
			foreach ( $menus as $single_menu ) {
				if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->slug ) ) {
					$custom_menus[ $single_menu->slug ] = $single_menu->name;
				}
			}
		}

		/**
		 * Mega menu metaboxes
		 */
		$meta_boxes[] = array(
			'id' => 'mega_menu_metabox',
			'title' => esc_html__('Menus to Show in Mega Menu Dropdown', 'creatink'),
			'object_types' => array('mega_menu'), // post type
			'context' => 'normal',
			'priority' => 'high',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name' => esc_html__('Menu Title 1', 'creatink'),
					'desc' => '(Optional) Enter a title for this menu to show in the mega menu.',
					'id'   => $prefix . 'menu_title_1',
					'type' => 'text',
				),
				array(
				    'name'             => 'Menu Column 1',
				    'desc'             => 'Select an option',
				    'id'               => $prefix . 'menu_1',
				    'type'             => 'select',
				    'show_option_none' => true,
				    'default'          => '',
				    'options'          => $custom_menus,
				),
				array(
					'name' => esc_html__('Menu Title 2', 'creatink'),
					'desc' => '(Optional) Enter a title for this menu to show in the mega menu.',
					'id'   => $prefix . 'menu_title_2',
					'type' => 'text',
				),
				array(
				    'name'             => 'Menu Column 2',
				    'desc'             => 'Select an option',
				    'id'               => $prefix . 'menu_2',
				    'type'             => 'select',
				    'show_option_none' => true,
				    'default'          => '',
				    'options'          => $custom_menus,
				),
				array(
					'name' => esc_html__('Menu Title 3', 'creatink'),
					'desc' => '(Optional) Enter a title for this menu to show in the mega menu.',
					'id'   => $prefix . 'menu_title_3',
					'type' => 'text',
				),
				array(
				    'name'             => 'Menu Column 3',
				    'desc'             => 'Select an option',
				    'id'               => $prefix . 'menu_3',
				    'type'             => 'select',
				    'show_option_none' => true,
				    'default'          => '',
				    'options'          => $custom_menus,
				),
				array(
					'name' => esc_html__('Menu Title 4', 'creatink'),
					'desc' => '(Optional) Enter a title for this menu to show in the mega menu.',
					'id'   => $prefix . 'menu_title_4',
					'type' => 'text',
				),
				array(
				    'name'             => 'Menu Column 4',
				    'desc'             => 'Select an option',
				    'id'               => $prefix . 'menu_4',
				    'type'             => 'select',
				    'show_option_none' => true,
				    'default'          => '',
				    'options'          => $custom_menus,
				)
			)
		);
		
		$meta_boxes[] = array(
			'id' => 'page_override_metabox',
			'title' => esc_html__('Page Overrides', 'creatink'),
			'object_types' => array('page', 'portfolio', 'team', 'post', 'career', 'product'), // post type
			'context' => 'normal',
			'priority' => 'low',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name'         => esc_html__( 'Override Header?', 'creatink' ),
					'desc'         => esc_html__( 'Header Layout is set in "appearance" -> "customise". To override this for this page only, use this control.', 'creatink' ),
					'id'           => $prefix . 'header_override',
					'type'         => 'select',
					'options'      => $header_overrides,
					'std'          => 'none'
				),
				array(
					'name'         => esc_html__( 'Override Footer?', 'creatink' ),
					'desc'         => esc_html__( 'Footer Layout is set in "appearance" -> "customise". To override this for this page only, use this control.', 'creatink' ),
					'id'           => $prefix . 'footer_override',
					'type'         => 'select',
					'options'      => $footer_overrides,
					'std'          => 'none'
				),
				array(
					'name'    => 'Background Image',
					'desc'    => 'Upload an image or enter an URL.',
					'id'      => $prefix . 'background_image',
					'type'    => 'file',
				),
				array(
					'name'    => 'Alternate Logo Image',
					'desc'    => 'Override this logo on this page only? Choose your replacement image here.',
					'id'      => $prefix . 'logo_override',
					'type'    => 'file',
				),
				array(
					'name'    => 'Alternate Retina Logo Image',
					'desc'    => 'Override this logo on this page only? Choose your replacement image here.',
					'id'      => $prefix . 'logo_retina_override',
					'type'    => 'file',
				),
				array(
					'name'    => 'Alternate Primary Color',
					'desc'    => 'Override this logo on this page only? Choose your replacement image here.',
					'id'      => $prefix . 'colour_override',
					'type'    => 'colorpicker',
					'default' => ''
				)
			)
		);
		
		$meta_boxes[] = array(
			'id' => 'post_override_metabox',
			'title' => esc_html__('Post Options', 'creatink'),
			'object_types' => array('post'), // post type
			'context' => 'normal',
			'priority' => 'low',
			'show_names' => true, // Show field names on the left
			'fields' => array(
				array(
					'name' => esc_html__('Featured Content Images', 'creatink' ),
					'desc' => esc_html__('Min Height 550px, Max 1400px, Drag & Drop to Reorder', 'creatink' ),
					'id' => $prefix . 'gallery_images',
					'type' => 'file_list',
				),
				array(
					'name' => esc_html__('Video Featured Content oEmbed', 'creatink' ),
					'desc' => 'Enter a Youtube or Vimeo URL. Supports services listed <a href="http://codex.wordpress.org/Embeds" target="_blank">here</a>',
					'id'   => $prefix . 'the_oembed',
					'type' => 'oembed',
				),
				array(
					'name'         => esc_html__( 'Override Post Layout?', 'creatink' ),
					'desc'         => esc_html__( 'Post Layout is set in "appearance" -> "customise". To override this for this post only, use this control.', 'creatink' ),
					'id'           => $prefix . 'post_layout_override',
					'type'         => 'select',
					'options'      => $post_overrides,
					'std'          => 'none'
				)
			)
		);
		
		return $meta_boxes;
	}
	add_filter( 'cmb2_meta_boxes', 'ebor_custom_metaboxes' );
}