<?php 

/**
 * Register Menu Locations For The Theme
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( function_exists('ebor_register_nav_menus') )){
	function ebor_register_nav_menus() {
		register_nav_menus( 
			array(
				'primary'  => esc_html__( 'Standard Navigation', 'creatink' )
			) 
		);
	}
	add_action( 'init', 'ebor_register_nav_menus' );
}

if(!( function_exists('ebor_register_sidebars') )){
	function ebor_register_sidebars() {
	
		register_sidebar( 
			array(
				'id' => 'primary',
				'name' => esc_html__( 'Blog Sidebar', 'creatink' ),
				'description' => esc_html__( 'Widgets to be displayed in the blog sidebar.', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s sidebox">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			) 
		);

		register_sidebar( 
			array(
				'id' => 'shop',
				'name' => esc_html__( 'Shop Sidebar', 'creatink' ),
				'description' => esc_html__( 'Widgets to be displayed in the shop sidebar.', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s sidebox">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			) 
		);

		register_sidebar(
			array(
				'id' => 'footer1',
				'name' => esc_html__( 'Footer Column 1', 'creatink' ),
				'description' => esc_html__( 'If this is set, your footer will be 1 column', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'footer2',
				'name' => esc_html__( 'Footer Column 2', 'creatink' ),
				'description' => esc_html__( 'If this & column 1 are set, your footer will be 2 columns.', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'footer3',
				'name' => esc_html__( 'Footer Column 3', 'creatink' ),
				'description' => esc_html__( 'If this & column 1 & column 2 are set, your footer will be 3 columns.', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'footer4',
				'name' => esc_html__( 'Footer Column 4', 'creatink' ),
				'description' => esc_html__( 'If this & column 1 & column 2 & column 3 are set, your footer will be 4 columns.', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'centered-footer',
				'name' => esc_html__( 'Centered Footer', 'creatink' ),
				'description' => esc_html__( 'This widget area is used within the Centered Footer Style', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="text-center widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);

		register_sidebar(
			array(
				'id' => 'light-footer1',
				'name' => esc_html__( 'Light/Dark Footer Column 1', 'creatink' ),
				'description' => esc_html__( 'If this is set, your footer will be 1 column', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'light-footer2',
				'name' => esc_html__( 'Light/Dark Footer Column 2', 'creatink' ),
				'description' => esc_html__( 'If this & column 1 are set, your footer will be 2 columns.', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'light-footer3',
				'name' => esc_html__( 'Light/Dark Footer Column 3', 'creatink' ),
				'description' => esc_html__( 'If this & column 1 & column 2 are set, your footer will be 3 columns.', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);
		
		register_sidebar(
			array(
				'id' => 'light-footer4',
				'name' => esc_html__( 'Light/Dark Footer Column 4', 'creatink' ),
				'description' => esc_html__( 'If this & column 1 & column 2 & column 3 are set, your footer will be 4 columns.', 'creatink' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h5 class="widget-title">',
				'after_title' => '</h5>'
			)
		);
		
	}
	add_action( 'widgets_init', 'ebor_register_sidebars' );
}

/**
 * Bootstrap nav walker
 * 
 * @since 1.0.0
 * @author tommusrhodus
 */
if(!( class_exists('ebor_bootstrap_navwalker') )){
	class ebor_bootstrap_navwalker extends Walker_Nav_Menu {
	
		/**
		 * @see Walker::start_lvl()
		 * @since 3.0.0
		 *
		 * @param string $output Passed by reference. Used to append additional content.
		 * @param int $depth Depth of page. Used for padding.
		 */
		public function start_lvl( &$output, $depth = 0, $args = array() ) {
			$indent = str_repeat( "\t", $depth );
			if( 1 == $depth ){
				$output .= "\n$indent<ul role=\"menu\" class=\" dropdown-menu pull-left\">\n";
			} else {
				$output .= "\n$indent<ul role=\"menu\" class=\" dropdown-menu\">\n";
			}
		}
	
		/**
		 * @see Walker::start_el()
		 * @since 3.0.0
		 *
		 * @param string $output Passed by reference. Used to append additional content.
		 * @param object $item Menu item data object.
		 * @param int $depth Depth of menu item. Used for padding.
		 * @param int $current_page Menu item ID.
		 * @param object $args
		 */
		public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
	
			/**
			 * Dividers, Headers or Disabled
			 * =============================
			 * Determine whether the item is a Divider, Header, Disabled or regular
			 * menu item. To prevent errors we use the strcasecmp() function to so a
			 * comparison that is not case sensitive. The strcasecmp() function returns
			 * a 0 if the strings are equal.
			 */
			if ( strcasecmp( $item->attr_title, 'divider' ) == 0 && $depth === 1 ) {
				$output .= $indent . '<li role="presentation" class="divider">';
			} else if ( strcasecmp( $item->title, 'divider') == 0 && $depth === 1 ) {
				$output .= $indent . '<li role="presentation" class="divider">';
			} else if ( strcasecmp( $item->attr_title, 'dropdown-header') == 0 && $depth === 1 ) {
				$output .= $indent . '<li role="presentation" class="dropdown-header">' . esc_attr( $item->title );
			} else if ( strcasecmp($item->attr_title, 'disabled' ) == 0 ) {
				$output .= $indent . '<li role="presentation" class="disabled"><a href="#">' . esc_attr( $item->title ) . '</a>';
			} else {
	
				$class_names = $value = '';
	
				$classes = empty( $item->classes ) ? array() : (array) $item->classes;
				$classes[] = 'menu-item-' . $item->ID;
	
				$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
	
				if ( $args->has_children && $depth == 0 ){
					$class_names .= ' dropdown';
				} elseif ( $args->has_children ){
					$class_names .= ' dropdown-submenu';
				}
	
				if ( in_array( 'current-menu-item', $classes ) )
					$class_names .= ' active';
	
				$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
	
				$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
				$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';
				
				if(!( $item->object == 'mega_menu' )) {
					$output .= $indent . '<li' . $id . $value . $class_names .'>';
				}
	
				$atts = array();
				$atts['target'] = ! empty( $item->target )	? $item->target	: '';
				$atts['rel']    = ! empty( $item->xfn )		? $item->xfn	: '';
				$atts['title']    = ! empty( $item->attr_title ) ? $item->attr_title	: '';
				$atts['class']    = ! empty( $item->attr_class ) ? $item->attr_class	: '';
	
				// If item has_children add atts to a.
				if ( $args->has_children && $depth === 0 ) {
					$atts['href'] = ! empty( $item->url ) ? $item->url : '';
					$atts['data-toggle']	= 'dropdown';
					$atts['class']			= 'dropdown-toggle js-activated';
				} else {
					$atts['href'] = ! empty( $item->url ) ? $item->url : '';
				}
	
				$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );
	
				$attributes = '';
				foreach ( $atts as $attr => $value ) {
					if ( ! empty( $value ) ) {
						$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
						$attributes .= ' ' . $attr . '="' . $value . '"';
					}
				}
				
				/**
				 * Check if menu item object is a mega menu object.
				 * If it is, display the mega menu content.
				 * Otherwise render elements as normal
				 */
				if( $item->object == 'mega_menu' ) {
					
					$mega_menu_class = '12';
					$menu_1 = get_post_meta($item->object_id, '_ebor_menu_1', 1);
					$menu_2 = get_post_meta($item->object_id, '_ebor_menu_2', 1);
					$menu_3 = get_post_meta($item->object_id, '_ebor_menu_3', 1);
					$menu_4 = get_post_meta($item->object_id, '_ebor_menu_4', 1);
					
					if(!( '' == $menu_2 )){
						$mega_menu_class = '6';
					}
					
					if(!( '' == $menu_3 )){
						$mega_menu_class = '4';
					}
					
					if(!( '' == $menu_4 )){
						$mega_menu_class = '3';
					}
					
					$output .= '<li class="mega-menu '. $atts['class'] .'"><a href="#">'. $item->title .' <span class="caret"></span></a><ul class="dropdown-menu mega-menu"><li class="mega-menu-content"><div class="row">';
					
					if(!( '' == $menu_1 )){
						
						$menu_post = wp_get_nav_menu_items($menu_1);
						
						$output .= '<div class="col-md-'. $mega_menu_class .'">';
						
						if( $title = get_post_meta($item->object_id, '_ebor_menu_title_1', 1) ){
							$output .= '<h3>'. $title .'</h3>';	
						}
						
						$output .= '<ul class="list-unstyled">';
					            
					    foreach( $menu_post as $menu_item ){
					    	$before = '<a href="'. $menu_item->url .'">';
					    	$after  = '</a>';
					    	
					    	$output .= '<li class="'. implode(' ', $menu_item->classes) .'">'. $before . $menu_item->title . $after .'</li>';	
					    }
					    
					    $output .= '</ul></div>';	
						
					}
					
					if(!( '' == $menu_2 )){
						
						$menu_post = wp_get_nav_menu_items($menu_2);
						
						$output .= '<div class="col-md-'. $mega_menu_class .'">';
						
						if( $title = get_post_meta($item->object_id, '_ebor_menu_title_2', 1) ){
							$output .= '<h3>'. $title .'</h3>';	
						}
						
						$output .= '<ul class="list-unstyled">';
					            
					    foreach( $menu_post as $menu_item ){
					    	$before = '<a href="'. $menu_item->url .'">';
					    	$after  = '</a>';
					    	
					    	$output .= '<li class="'. implode(' ', $menu_item->classes) .'">'. $before . $menu_item->title . $after .'</li>';	
					    }
					    
					    $output .= '</ul></div>';	
						
					}
					
					if(!( '' == $menu_3 )){
						
						$menu_post = wp_get_nav_menu_items($menu_3);
						
						$output .= '<div class="col-md-'. $mega_menu_class .'">';
						
						if( $title = get_post_meta($item->object_id, '_ebor_menu_title_3', 1) ){
							$output .= '<h3>'. $title .'</h3>';	
						}
						
						$output .= '<ul class="list-unstyled">';
					            
					    foreach( $menu_post as $menu_item ){
					    	$before = '<a href="'. $menu_item->url .'">';
					    	$after  = '</a>';
					    	
					    	$output .= '<li class="'. implode(' ', $menu_item->classes) .'">'. $before . $menu_item->title . $after .'</li>';	
					    }
					    
					    $output .= '</ul></div>';	
						
					}
					
					if(!( '' == $menu_4 )){
						
						$menu_post = wp_get_nav_menu_items($menu_4);
						
						$output .= '<div class="col-md-'. $mega_menu_class .'">';
						
						if( $title = get_post_meta($item->object_id, '_ebor_menu_title_4', 1) ){
							$output .= '<h3>'. $title .'</h3>';	
						}
						
						$output .= '<ul class="list-unstyled">';
					            
					    foreach( $menu_post as $menu_item ){
					    	$before = '<a href="'. $menu_item->url .'">';
					    	$after  = '</a>';
					    	
					    	$output .= '<li class="'. implode(' ', $menu_item->classes) .'">'. $before . $menu_item->title . $after .'</li>';	
					    }
					    
					    $output .= '</ul></div>';	
						
					}        
						      
					$output .= '</div></li></ul></li>';
					
				} else {
					
					$item_output = $args->before;
					$item_output .= '<a'. $attributes .'>';
					$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
					if ( $args->has_children && $depth >= 0 ){
						$item_output .= ' <span class="caret"></span>';
					}
					$item_output .= ( $args->has_children && 0 === $depth ) ? '</a>' : '</a>';
					$item_output .= $args->after;
					
					$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
					
				}
	
			}
		}
	
		/**
		 * Traverse elements to create list from elements.
		 *
		 * Display one element if the element doesn't have any children otherwise,
		 * display the element and its children. Will only traverse up to the max
		 * depth and no ignore elements under that depth.
		 *
		 * This method shouldn't be called directly, use the walk() method instead.
		 *
		 * @see Walker::start_el()
		 * @since 2.5.0
		 *
		 * @param object $element Data object
		 * @param array $children_elements List of elements to continue traversing.
		 * @param int $max_depth Max depth to traverse.
		 * @param int $depth Depth of current element.
		 * @param array $args
		 * @param string $output Passed by reference. Used to append additional content.
		 * @return null Null on failure with no changes to parameters.
		 */
		public function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
	        if ( ! $element )
	            return;
	
	        $id_field = $this->db_fields['id'];
	
	        // Display this element.
	        if ( is_object( $args[0] ) )
	           $args[0]->has_children = ! empty( $children_elements[ $element->$id_field ] );
	
	        parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	    }
	
	}
}