<?php 

/**
 * Returns an array of all available shop layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_shop_layouts') )){
	function ebor_get_shop_layouts(){
		
		$options = array(
			'Grid 3 Columns'                 => 'grid-3',
			'Grid 4 Columns'                 => 'grid-4',
			'Grid with Right Sidebar'        => 'grid-sidebar-right',
			'Grid with Left Sidebar'         => 'grid-sidebar-left',
			'Box Grid 4 Columns'             => 'grid-4-box',
			'Box Grid 3 Columns'             => 'grid-3-box',
			'Box Grid with Right Sidebar'    => 'grid-sidebar-right-box',
			'Box Grid with Left Sidebar'     => 'grid-sidebar-left-box',
			'Border Grid 4 Columns'          => 'grid-4-border',
			'Border Grid 3 Columns'          => 'grid-3-border',
			'Border Grid with Right Sidebar' => 'grid-sidebar-right-border',
			'Border Grid with Left Sidebar'  => 'grid-sidebar-left-border',
			'Carousel'                       => 'carousel'
		);
		
		if( has_filter('ebor_add_shop_layouts') ) {
			$options = apply_filters('ebor_add_shop_layouts', $options);
		}
		
		return $options;
		
	}
}

/**
 * Returns an array of all available Pagination layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_pagination_layouts') )){
	function ebor_get_pagination_layouts(){
		
		$options = array(
			'Bordered Pagination'      => 'pagination border text-center',
			'Hollow Pagination'        => 'pagination text-center',
			'Round Hollow Pagination'  => 'pagination round round-simple text-center',
			'Round Pagination'         => 'pagination round text-center',
			'Boxed Pagination'         => 'pagination boxed text-center',
		);
		
		if( has_filter('ebor_add_pagination_layouts') ) {
			$options = apply_filters('ebor_add_pagination_layouts', $options);
		}
		
		return $options;
		
	}
}

/**
 * Returns an array of all available header layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_header_options') )){
	function ebor_get_header_options(){
		$options = array(
			'blank'                      => 'No Header',
			'classic-light'              => 'Light Classic Header',
			'classic-dark'               => 'Dark Classic Header',
			'top-bar-classic-light'		 => 'Light Classic Header & Top Bar',
			'top-bar-classic-dark'       => 'Dark Classic Header & Top Bar',
			'centered-light'             => 'Light Centered Header',
			'centered-dark'              => 'Dark Centered Header',
			'centered-transparent'		 => 'Transparent Centered Header',
			'extended'                   => 'Extended Header',
			'fancy'                      => 'Fancy Header',
			'top-bar-fancy'           	 => 'Fancy Header & Top Bar',
			'wide-transparent'         	 => 'Transparent Wide Header',
			'centered-wide'              => 'Centered Wide Header',
			'centered-wide-dark'         => 'Dark Centered Wide Header',
			'centered-wide-transparent'  => 'Transparent Centered Wide Header',
			'opacity-centered-wide'  	 => 'Opacity Centered Wide Header',
			'centered-wide-transparent-dark'  => 'Transparent Dark Centered Wide Header',
			'classic-transparent'        => 'Transparent Light Header',
			'transparent-dark'           => 'Transparent Dark Header',
			'top-bar-classic-transparent'=> 'Transparent Light Header & Top Bar',
			'top-bar-transparent-dark'	 => 'Transparent Dark Header & Top Bar',
			'opacity-light'              => 'Opacity Light Header',
			'opacity-dark'               => 'Opacity Dark Header',
			'top-bar-opacity-light'		 => 'Opacity Light Header & Top Bar',
			'top-bar-opacity-dark'       => 'Opacity Dark Header & Top Bar',
			'centered-light-alternative' => 'Centered Light Alternative Header',
			'centered-dark-alternative'  => 'Centered Dark Alternative Header',
			'centered-wide-alternative'  => 'Centered Wide Alternative Header',
			'top-bar-centered-dark-alternative'  => 'Centered Dark Alternative Header & Top Bar',
		);
		
		if( has_filter('ebor_add_header_layouts') ) {
			$options = apply_filters('ebor_add_header_layouts', $options);
		}
		
		return $options;	
	}
}

/**
 * Returns an array of all available footer layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_footer_options') )){
	function ebor_get_footer_options(){
		$options = array(
			'blank'                     => 'No Footer',
			'simple'                    => 'Simple Footer',
			'simple-light'              => 'Light Simple Footer',
			'simple-light-wide'         => 'Light Simple Footer Wide',
			'simple-centered'           => 'Simple Centered Footer',
			'detailed-centered'         => 'Detailed Centered Footer',
			'widgets'                   => 'Widgets Footer',
			'light'                     => 'Light Footer',
			'dark'                      => 'Dark Footer',
			'image'                     => 'Image Footer',
			'dark-image'                => 'Dark Image Footer',
			'image-widgets'             => 'Widgets Image Footer',
		);
		
		if( has_filter('ebor_add_footer_layouts') ) {
			$options = apply_filters('ebor_add_footer_layouts', $options);
		}
		
		return $options;	
	}
}

/**
 * Returns an array of all available Single Post layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_single_post_layouts') )){
	function ebor_get_single_post_layouts(){
		
		$options = array(
			'Post With Sidebar Right'       => 'post-sidebar-right',
			'Post With Sidebar Left'        => 'post-sidebar-left',
			'Post With No Sidebar'          => 'post',
			'Boxed Post With Sidebar Right' => 'post-box-sidebar-right',
			'Boxed Post With Sidebar Left'  => 'post-box-sidebar-left',
			'Boxed Post With No Sidebar'    => 'post-box',
		);
		
		if( has_filter('ebor_add_single_post_layouts') ) {
			$options = apply_filters('ebor_add_single_post_layouts', $options);
		}
		
		return $options;
		
	}
}

/**
 * Returns an array of all available Single portfolio layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_single_portfolio_layouts') )){
	function ebor_get_single_portfolio_layouts(){
		
		$options = array(
			'Featured Content Left'             => 'content-left',
			'Featured Content Right'            => 'content-right',
			'Featured Content Top'              => 'content-top',
			'Featured Content Bottom'           => 'content-bottom',
			'Featured Content Top Fullwidth'    => 'content-top-full',
			'Featured Content Bottom Fullwidth' => 'content-bottom-full'
		);
		
		if( has_filter('ebor_add_single_portfolio_layouts') ) {
			$options = apply_filters('ebor_add_single_portfolio_layouts', $options);
		}
		
		return $options;
		
	}
}

/**
 * Returns an array of all available Single portfolio layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_single_portfolio_content_layouts') )){
	function ebor_get_single_portfolio_content_layouts(){
		
		$options = array(
			'Slider With Minimal Arrows' => 'slider-arrows',
			'Slider With Boxed Arrows'   => 'slider-box-arrows',
			'Thumbnail Slider'           => 'thumbnail-slider',
			'Video'                      => 'video',
			'Masonry Images'             => 'masonry',
			'Simple Image List'          => 'images',
			'Image Grid'                 => 'image-grid',
			'Comparison Slider'          => 'comparison-slider',
			'Carousel'                   => 'carousel'
		);
		
		if( has_filter('ebor_add_single_portfolio_content_layouts') ) {
			$options = apply_filters('ebor_add_single_portfolio_content_layouts', $options);
		}
		
		return $options;
		
	}
}

/**
 * Returns an array of all available blog layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_blog_layouts') )){
	function ebor_get_blog_layouts(){
		
		$options = array(
			'Grid Sidebar Right'               => 'grid-sidebar-right',
			'Grid Sidebar Left'                => 'grid-sidebar-left',
			'Grid No Sidebar'                  => 'grid',
			'Grid Boxed Sidebar Right'         => 'grid-box-sidebar-right',
			'Grid Boxed Sidebar Left'          => 'grid-box-sidebar-left',
			'Grid Boxed No Sidebar'            => 'grid-box',
			'List No Sidebar'                  => 'list',
			'List Sidebar Left'                => 'list-sidebar-left',
			'List Sidebar Right'               => 'list-sidebar-right',
			'Boxed List No Sidebar'            => 'list-box',
			'Boxed List Sidebar Left'          => 'list-box-sidebar-left',
			'Boxed List Sidebar Right'         => 'list-box-sidebar-right',
			'Classic Blog'                     => 'classic',
			'Classic Blog Sidebar Left'        => 'classic-sidebar-left',
			'Classic Blog Sidebar Right'       => 'classic-sidebar-right',
			'Magazine Blog'                    => 'magazine',
			'Magazine Blog Sidebar Left'       => 'magazine-sidebar-left',
			'Magazine Blog Sidebar Right'      => 'magazine-sidebar-right',
			'Boxed Classic Blog'               => 'classic-box',
			'Boxed Classic Blog Sidebar Left'  => 'classic-box-sidebar-left',
			'Boxed Classic Blog Sidebar Right' => 'classic-box-sidebar-right',
			'Image Grid'                       => 'image-grid',
			'Image Grid Sidebar Left'          => 'image-grid-sidebar-left',
			'Image Grid Sidebar Right'         => 'image-grid-sidebar-right',
			'Newspaper Grid'                   => 'newspaper-grid',
			'Newspaper Grid Sidebar Left'      => 'newspaper-grid-sidebar-left',
			'Newspaper Grid Sidebar Right'     => 'newspaper-grid-sidebar-right',
			'Carousel'                         => 'carousel',
			'Alternate Carousel'               => 'carousel-alt',
			'Newspaper Carousel'               => 'carousel-newspaper',
			'Image Grid Carousel'              => 'carousel-image-grid',
			'Grid Box Carousel'                => 'carousel-grid-box',
			'Slick Carousel'                   => 'carousel-slick',
			'Slider'                           => 'slider',
		);
		
		if( has_filter('ebor_add_blog_layouts') ) {
			$options = apply_filters('ebor_add_blog_layouts', $options);
		}
		
		return $options;
		
	}
}

/**
 * Returns an array of all available team layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_team_layouts') )){
	function ebor_get_team_layouts(){
		
		$options = array(
			'Carousel Boxed'  => 'carousel-box',
			'Carousel'        => 'carousel',
			'Carousel Border' => 'carousel-border',
			'Columns'         => 'columns',
			'Columns Box'     => 'columns-box',
			'Columns Border'  => 'columns-border',
			'List'            => 'list'
		);
		
		if( has_filter('ebor_add_team_layouts') ) {
			$options = apply_filters('ebor_add_team_layouts', $options);
		}
		
		return $options;
		
	}
}

/**
 * Returns an array of all available portfolio layouts
 * 
 * @val array
 * @since 1.0.0
 * @package Creatink
 * @author TommusRhodus
 */
if(!( function_exists('ebor_get_portfolio_layouts') )){
	function ebor_get_portfolio_layouts(){
		
		$options = array(
			'Classic Grid'                    => 'classic-grid',
			'Classic Grid Lightbox'           => 'classic-grid-lightbox',
			'Masonry Grid 3 Columns'          => 'masonry-grid',
			'Masonry Grid 3 Columns Lightbox' => 'masonry-grid-lightbox',
			'Masonry Grid 2 Columns'          => 'masonry-grid-2',
			'Fullscreen Grid'                 => 'fullscreen-grid',
			'Fullscreen Grid Lightbox'        => 'fullscreen-grid-lightbox',
			'Justified Grid'                  => 'justified-grid',
			'Justified Grid Lightbox'         => 'justified-grid-lightbox',
			'Modal Portfolio'                 => 'modal',
			'Modal Portfolio Lightbox'        => 'modal-lightbox',
			'Carousel 3 Columns'              => 'carousel',
			'Carousel 3 Columns Lightbox'     => 'carousel-lightbox',
			'Carousel Single'                 => 'carousel-single',
			'Mosaic Portfolio'                => 'mosaic',
			'Mosaic Portfolio Lightbox'       => 'mosaic-lightbox',
			'Large Masonry'                   => 'masonry-grid-large',
			'Large Masonry Lightbox'          => 'masonry-grid-large-lightbox',
			'Static Grid'                     => 'static-grid',
			'Static Grid Lightbox'            => 'static-grid-lightbox',
		);
		
		if( has_filter('ebor_add_portfolio_layouts') ) {
			$options = apply_filters('ebor_add_portfolio_layouts', $options);
		}
		
		return $options;
		
	}
}