<?php 

/**
 * Filter menu item classes into wp_get_nav_menu_items() array return
 */
if(!( function_exists('ebor_nav_menu_classes') )){
	function ebor_nav_menu_classes($items, $menu, $args) {
	    _wp_menu_item_classes_by_context($items);
	    return $items;
	}
	add_filter( 'wp_get_nav_menu_items', 'ebor_nav_menu_classes', 10, 3 );
}

/**
 * Add a clearfix to the end of the_content()
 */
if(!( function_exists('ebor_add_clearfix') )){ 
	function ebor_add_clearfix( $content ) { 
		$content .= '<div class="clearfix"></div>';
	    return $content;
	}
	add_filter( 'the_content', 'ebor_add_clearfix' ); 
}

if(!( function_exists('ebor_excerpt_length') )){
	function ebor_excerpt_length( $length ) {
		return 22;
	}
	add_filter( 'excerpt_length', 'ebor_excerpt_length', 999 );
}

if(!( function_exists('ebor_excerpt_more') )){
	function ebor_excerpt_more( $more ) {
		return '...';
	}
	add_filter('excerpt_more', 'ebor_excerpt_more');
}

function ebor_cf7_remove_attr_size( $content ) {
	$content = preg_replace('/ size=".*?"/i', ' ', $content);
	return $content;
}
add_filter( 'wpcf7_form_elements', 'ebor_cf7_remove_attr_size' );
	
if(!( function_exists('ebor_add_body_classes') )){ 
	function ebor_add_body_classes($classes) {
		global $post;
		
		if( isset($post->ID) && get_post_meta($post->ID, '_ebor_background_image', 1) ){
			$classes[] = 'box-layout pt-0';
		}
        
        return $classes;
        
	}
	add_filter('body_class', 'ebor_add_body_classes');
}

function ebor_add_to_body_tag(){
	global $post;
	
	if( isset($post->ID) && $image = get_post_meta($post->ID, '_ebor_background_image', 1) ){
		echo 'style="background-image: url('. $image .');"';
	}
	
}
add_action( 'ebor_body_tag', 'ebor_add_to_body_tag' );

if(!( function_exists('ebor_page_loader') )){ 
	function ebor_page_loader() {
		
		if( 'yes' == get_option('creatink_show_loader', 'no' ) ){
			
			get_template_part( 'inc/content', 'loader' );
			
		}
        
	}
	add_action('ebor_before_header', 'ebor_page_loader', 10);
}

if(!( function_exists('ebor_tinymce_fix') )){
	function ebor_tinymce_fix( $init ){
	    $init['extended_valid_elements'] = 'i[*]';
	    return $init;
	}
	add_filter('tiny_mce_before_init', 'ebor_tinymce_fix');
}

/**
 * Add additional settings to gallery shortcode
 */
if(!( function_exists('ebor_add_gallery_settings') )){ 
	function ebor_add_gallery_settings(){
?>
	
		<script type="text/html" id="tmpl-stack-gallery-setting">
			<h3>Creatink Theme Gallery Settings</h3>
			<label class="setting">
				<span><?php esc_html_e('Gallery Layout', 'creatink'); ?></span>
				<select data-setting="layout">
					<option value="default">Default Layout</option>    
					<option value="carousel">Creatink Carousel</option> 
					<option value="lightbox-carousel">Creatink Lightbox Carousel</option> 
					<option value="carousel-photography">Creatink Photography Carousel</option>
					<option value="comparison">Creatink Comparison Slider</option>
					<option value="slider">Creatink Slider</option>
					<option value="slick-carousel">Creatink Slick Carousel</option> 
					<option value="thumbnail">Creatink Thumbnail Slider</option> 
					<option value="fullscreen">Creatink Fullscreen Thumbnail Slider</option>
					<option value="collage">Creatink Collage Gallery</option>
					<option value="masonry">Creatink Masonry Gallery</option>
				</select>
			</label>
		</script>
	
		<script>
			jQuery(document).ready(function(){
				jQuery.extend(wp.media.gallery.defaults, { layout: 'default' });
				
				wp.media.view.Settings.Gallery = wp.media.view.Settings.Gallery.extend({
					template: function(view){
					  return wp.media.template('gallery-settings')(view)
					       + wp.media.template('stack-gallery-setting')(view);
					}
				});
			});
		</script>
	  
<?php
	}
	add_action('print_media_templates', 'ebor_add_gallery_settings');
}


/**
 * Custom gallery shortcode
 *
 * Filters the standard WordPress gallery shortcode.
 *
 * @since 1.0.0
 */
if(!( function_exists('ebor_post_gallery') )){
	function ebor_post_gallery( $output, $attr) {
		
		global $post, $wp_locale;
	
	    static $instance = 0;
	    $instance++;
	
	    // We're trusting author input, so let's at least make sure it looks like a valid orderby statement
	    if ( isset( $attr['orderby'] ) ) {
	        $attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
	        if ( !$attr['orderby'] )
	            unset( $attr['orderby'] );
	    }
	
	    extract(shortcode_atts(array(
	        'order'      => 'ASC',
	        'orderby'    => 'menu_order ID',
	        'id'         => $post->ID,
	        'itemtag'    => 'div',
	        'icontag'    => 'dt',
	        'captiontag' => 'dd',
	        'columns'    => 3,
	        'size'       => 'large',
	        'include'    => '',
	        'exclude'    => '',
	        'layout'     => ''
	    ), $attr));
	
	    $id = intval($id);
	    if ( 'RAND' == $order )
	        $orderby = 'none';
	
	    if ( !empty($include) ) {
	        $include = preg_replace( '/[^0-9,]+/', '', $include );
	        $_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	
	        $attachments = array();
	        foreach ( $_attachments as $key => $val ) {
	            $attachments[$val->ID] = $_attachments[$key];
	        }
	    } elseif ( !empty($exclude) ) {
	        $exclude = preg_replace( '/[^0-9,]+/', '', $exclude );
	        $attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	    } else {
	        $attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	    }
	
	    if ( empty($attachments) )
	        return '';
	
	    if ( is_feed() ) {
	        $output = "\n";
	        foreach ( $attachments as $att_id => $attachment )
	            $output .= wp_get_attachment_link($att_id, $size, true) . "\n";
	        return $output;
	    }
	    
	    if( 'slider' == $layout ){
	    
	    	$output = '<div class="slick-wrapper"><div class="slick text-center mb-40" data-slick=\'{"slidesToShow": 1}\'>';
			
			foreach ( $attachments as $id => $attachment ) {  
				$output .= '<div class="item">'. wp_get_attachment_image($id, 'large') .'</div>';
			}
			
			$output .= '	
				</div>
				<div class="slick-nav-container inner-arrows bg light-bg">
					<div class="slick-nav"></div>
				</div>
				</div>
			';
			
			return $output;

	    }
	    
	    if( 'comparison' == $layout ){
	    	
	    	$output = '<div class="cocoen" data-aos="fade">';
	    	
	    	foreach ( $attachments as $id => $attachment ) {  
	    		$output .= wp_get_attachment_image($id, 'large');
	    	}
	    	
	    	$output .= '</div>';	
	    	
	    	return $output;
	    	
	    }
	    
	    if( 'carousel' == $layout ){

	    	$output = '<div class="slick-wrapper"><div class="slick var-slick text-center" data-slick=\'{"slidesToShow": 1, "dots": false, "infinite": true, "variableWidth": true}\'>';
	    	
	    	foreach ( $attachments as $id => $attachment ) {  
	    		$output .= '<div class="item mr-5 ml-5">'. wp_get_attachment_image($id, 'large') .'</div>';
	    	}
	    	
	    	$output .= '</div><div class="slick-nav-container inner-arrows bg light-bg"><div class="slick-nav"></div></div></div>';
	    	
	    	return $output;
	    	
	    }

	    if( 'carousel-photography' == $layout ){
	    	
	    	$output = '<div class="slick-wrapper"><div class="slick var-slick vh100 text-center light-gallery" data-slick=\'{"slidesToShow": 1, "dots": false, "infinite": true, "variableWidth": true}\'>';
	    	
	    	foreach ( $attachments as $id => $attachment ) {  
	    	
	    		$src = wp_get_attachment_image_src($id, 'full');
	    		
	    		$output .= '
	    			<div class="item mr-10 ml-10">
	    			
	    				'. wp_get_attachment_image($id, 'large') .'
	    				
	    				<div class="link-wrapper">
	    					<div class="link lightbox light-bg">
	    						<a href="'. $src[0] .'" data-sub-html="#caption'. $id .'" class="lightbox-this"></a>
	    					</div>
	    				</div>
	    				
	    				<div id="caption'. $id .'" class="hidden">
	    					<p>Purus Vulputate Sem</p>
	    				</div>
	    				
	    			</div><!--/.item -->
	    		';
	    		
	    	}
	    	
	    	$output .= '</div><div class="slick-nav-container inner-arrows bg light-bg"><div class="slick-nav"></div></div></div>';
	    	
	    	return $output;
	    	
	    }
	    
	    if( 'slick-carousel' == $layout ){
	    	
	    	$output = '<div class="slick-wrapper"><div class="slick text-center" data-slick=\'{"slidesToShow": 3, "infinite": true, "responsive": [{"breakpoint":992,"settings":{"slidesToShow": 1}},{"breakpoint":1680,"settings":{"slidesToShow": 2}}]}\'>';
	    	
	    	foreach ( $attachments as $id => $attachment ) {  
	    		$output .= '<div class="item pl-5 pr-5">'. wp_get_attachment_image($id, 'large') .'</div>';
	    	}
	    	
	    	$output .= '</div><div class="slick-nav-container inner-arrows bg light-bg"><div class="slick-nav"></div></div></div>';	
	    		
	    	return $output;
	    	
	    }
	    
	    if( 'thumbnail' == $layout ){
	    	
	    	$output = '
				<div class="fotorama-wrapper">
				<div class="fotorama nav-bg nav-bg-light caption-bg-light"
					 data-arrows="true"
					 data-nav="thumbs"
					 data-width="100%"			
					 data-maxheight="100%"
					 data-transition="slide"
					 data-thumbwidth="90"
					 data-thumbheight="60"
				>';
				
			foreach ( $attachments as $id => $attachment ) {  
				$output .= wp_get_attachment_image($id, 'full');
			}
				
			$output .= '</div></div>';
	    	
	    	return $output;
	    		
	    }
	    
	    if( 'fullscreen' == $layout ){
	    	
	    	$output = '
	    		<div class="fotorama-wrapper fotorama-fullscreen">
	    		<div class="fotorama"
	    			 data-width="100%" 
	    			 data-height="100%" 
	    			 data-autoplay="8000"
	    			 data-keyboard="true"
	    			 data-arrows="true"
	    			 data-click="false"
	    			 data-fit="cover"
	    			 data-swipe="true"
	    			 data-nav="thumbs"
	    			 data-transition="slide"
	    			 data-clicktransition="crossfade"
	    			 data-thumbwidth="90"
	    			 data-thumbheight="60"
	    		>';
	    		
	    	foreach ( $attachments as $id => $attachment ) {  
	    		$output .= wp_get_attachment_image($id, 'full');
	    	}
	    		
	    	$output .= '</div></div>';
	    	
	    	return $output;
	    		
	    }
	    
		if( 'lightbox-carousel' == $layout ){
			
		    $output = '<div class="slick-wrapper"><div class="slick var-slick h500 light-gallery text-center" data-slick=\'{"slidesToShow": 1, "dots": false, "infinite": true, "variableWidth": true}\'>';
				
			foreach ( $attachments as $id => $attachment ) {  
				$src = wp_get_attachment_image_src($id, 'full');
				$output .= '<div class="item mr-5 ml-5">'. wp_get_attachment_image($id, 'large') .'<div class="link-wrapper"><div class="link"><a href="'. esc_url($src[0]) .'" class="lightbox-this"></a></div></div></div>';
			}
				
			$output .= '</div><div class="slick-nav-container inner-arrows bg dark-bg"><div class="slick-nav"></div></div></div>';
			
			return $output;
	    
		}
		
		if( 'collage' == $layout ){
		
			$output = '<div class="collage-wrapper"><div id="collage-large" class="collage effect-parent light-gallery">';
			
			foreach ( $attachments as $id => $attachment ) {  
				$src = wp_get_attachment_image_src($id, 'full');
				$output .= '
					<div class="collage-image-wrapper">
					<div class="overlay overlay1"><a href="'. esc_url($src[0]) .'" class="lightbox-this" data-sub-html="#caption'. $id .'"></a>'. wp_get_attachment_image($id, 'large') .'
					<div class="figcaption">
					<h5 class="from-top mb-0">'. esc_html__( 'Project Title', 'creatink') .'</h5>
					</div>
					<div id="caption'. $id .'" class="hidden">
					<h3>Dapibus Mattis Magna</h3>
					<p>Maecenas faucibus mollis interdum.</p>
					</div>
					</div>
					</div>
				';
			}
				
			$output .= '</div></div>';
			
			return $output;
		
		}
		
		if( 'masonry' == $layout ){
			
			$output = '<div class="portfolio grid-view text-center"><div class="tiles tiles-s"><div class="isotope row light-gallery grid-1"><div class="isotope-filter button-group text-center" data-target=".grid-1"></div>';
			
			foreach ( $attachments as $id => $attachment ) {  
				$src = wp_get_attachment_image_src($id, 'full');
				$output .= '
					<div class="item grid-sizer col-sm-6 col-md-6 web">
						<figure class="overlay overlay1">
							<a href="'. esc_url($src[0]) .'" class="lightbox-this" data-sub-html="#caption'. $id .'"></a>
							'. wp_get_attachment_image($id, 'large') .'
							<figcaption>
								<h5 class="from-top mb-0">'. esc_html__( 'Project Title', 'creatink') .'</h5>
							</figcaption>
						</figure>
						<div id="caption1" class="hidden">
							<h3>Project Title</h3>
							<p>Some description of the item</p>
						</div>
					</div>
				';
			}

			$output .= '</div></div></div>';
			
			return $output;
		
		}
		
	}
	add_filter( 'post_gallery', 'ebor_post_gallery', 10, 2 );
}

if( class_exists('OCDI_Plugin') ){
	
	function ebor_ocdi_plugin_intro_text( $default_text ) {
	    $default_text .= '
	    	<div class="ocdi__intro-text">
	    		<h3>Read this before importing demo data!</h3>
	    		<p>We have prepared full written & video documentation to make your life with Candar much more easy. It is worth spending a few minutes with this to familiarise yourself with the theme & its plugins before jumping in with your demo data, so <a href="https://tommusrhodus.ticksy.com/articles/" target="_blank">please read the theme documentation</a> before importing the demo data.</p>
	    		<hr />
	    	</div>
	    ';
	
	    return $default_text;
	}
	add_filter( 'pt-ocdi/plugin_intro_text', 'ebor_ocdi_plugin_intro_text' );
	
	function ebor_ocdi_confirmation_dialog_options ( $options ) {
	    return array_merge( $options, array(
	        'width'       => 600,
	        'dialogClass' => 'wp-dialog',
	        'resizable'   => false,
	        'height'      => 'auto',
	        'modal'       => true,
	    ) );
	}
	add_filter( 'pt-ocdi/confirmation_dialog_options', 'ebor_ocdi_confirmation_dialog_options', 10, 1 );
	
	//Setup basic demo import
	function ebor_import_files() {
		
		$import_notice_vc = '
			<h3>Ready to Import Creatink Demo Data?</h3>
			<p>Please ensure all required plugins in "appearance => install plugins" are installed before running this demo importer.</p>
			<p>Since you\'re importing Candar Demo Data, please ensure Visual Composer is enabled in "plugins".</p>
			<p><a href="https://tommusrhodus.ticksy.com/articles/" target="_blank">Please read the theme documentation.</a></p>
		';
		
				
	    return array(
	        array(
	            'import_file_name'             => 'Creatink + Visual Composer Demo Data',
	            'import_file_url'              => get_theme_file_uri( '/admin/demo-data/content.xml' ),
	            'import_widget_file_url'       => get_theme_file_uri( '/admin/demo-data/widgets.wie' ),
	            'import_customizer_file_url'   => get_theme_file_uri( '/admin/demo-data/customizer.dat' ),
	            'import_preview_image_url'     => get_theme_file_uri( '/screenshot.png' ),
	            'import_notice'                => $import_notice_vc,
	        ),
	    );
	    
	}
	add_filter( 'pt-ocdi/import_files', 'ebor_import_files' );
	
	//Setup front page and menus
	function ebor_after_import_setup() {
		
	    // Assign menus to their locations.
	    $main_menu = get_term_by( 'name', 'Standard Navigation', 'nav_menu' );
	
	    set_theme_mod( 'nav_menu_locations', array(
	            'primary'  => $main_menu->term_id
	        )
	    );
	
	    // Assign front page and posts page (blog page).
	    $front_page_id = get_page_by_title( 'Home - Classic Layout' );
	    $blog_page_id  = get_page_by_title( 'Blog' );
	
	    update_option( 'show_on_front', 'page' );
	    update_option( 'page_on_front', $front_page_id->ID );
	    update_option( 'page_for_posts', $blog_page_id->ID );
	
	}
	add_action( 'pt-ocdi/after_import', 'ebor_after_import_setup' );
	
	//Remove Branding
	add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
	
	//Save customize options
	add_action( 'pt-ocdi/enable_wp_customize_save_hooks', '__return_true' );
	
	//Stop thumbnail generation
	add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );
	
}